/*
 * Decompiled with CFR 0.152.
 */
package reborncore.common.util;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import reborncore.common.network.NetworkManager;
import reborncore.common.network.packet.CustomDescriptionPacket;

public class Tank
extends FluidTank {
    private final String name;
    private FluidStack lastBeforeUpdate = null;
    Fluid lastFluid;
    int lastAmmount;

    public Tank(String name, int capacity, TileEntity tile) {
        super(capacity);
        this.name = name;
        this.tile = tile;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tankData = new NBTTagCompound();
        super.writeToNBT(tankData);
        nbt.func_74782_a(this.name, (NBTBase)tankData);
        return nbt;
    }

    public void setFluidAmount(int amount) {
        if (this.fluid != null) {
            this.fluid.amount = amount;
        }
    }

    public final FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.name)) {
            this.setFluid(null);
            NBTTagCompound tankData = nbt.func_74775_l(this.name);
            super.readFromNBT(tankData);
        }
        return this;
    }

    public void compareAndUpdate() {
        if (this.tile == null || this.tile.func_145831_w().field_72995_K) {
            return;
        }
        if (this.lastFluid == null || this.lastFluid != null && this.getFluid() == null || this.getFluid().getFluid() == null || this.lastFluid != this.getFluid().getFluid() || this.lastAmmount != this.getFluidAmount()) {
            if (this.getFluid() == null) {
                this.lastFluid = null;
                this.lastAmmount = 0;
            } else {
                this.lastFluid = this.getFluid().getFluid();
                this.lastAmmount = this.getFluidAmount();
            }
            NetworkManager.sendToAllAround(new CustomDescriptionPacket(this.tile), new NetworkRegistry.TargetPoint(this.tile.func_145831_w().field_73011_w.getDimension(), (double)this.tile.func_174877_v().func_177958_n(), (double)this.tile.func_174877_v().func_177956_o(), (double)this.tile.func_174877_v().func_177952_p(), 20.0));
        }
    }
}

