/*
 * Decompiled with CFR 0.152.
 */
package me.jacky1356400.exchangers.handler;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.jacky1356400.exchangers.client.Keys;
import me.jacky1356400.exchangers.helper.ChatHelper;
import me.jacky1356400.exchangers.helper.StringHelper;
import me.jacky1356400.exchangers.item.ItemExchanger;
import me.jacky1356400.exchangers.item.ItemPoweredExchanger;
import me.jacky1356400.exchangers.util.StackUtil;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ExchangerHandler
extends Item {
    public static final int MODE_1X1 = 0;
    public static final int MODE_3X3 = 1;
    public static final int MODE_5X5 = 2;
    public static final int MODE_7X7 = 3;
    public static final int MODE_9X9 = 4;
    public static final int MODE_11X11 = 5;
    public static final int MODE_13X13 = 6;
    public static final int MODE_15X15 = 7;
    public static final int MODE_17X17 = 8;
    public static final int MODE_19X19 = 9;
    public static final int MODE_21X21 = 10;
    public static final int MODE_23X23 = 11;
    public static final int MODE_25X25 = 12;
    public static final String[] modeSwitchList = new String[]{"1x1", "3x3", "5x5", "7x7", "9x9", "11x11", "13x13", "15x15", "17x17", "19x19", "21x21", "23x23", "25x25"};

    public static void setDefaultTagCompound(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74768_a("block", 0);
        stack.func_77978_p().func_74768_a("meta", 0);
        stack.func_77978_p().func_74768_a("mode", 0);
    }

    public static boolean stackTagCompoundNull(ItemStack stack) {
        return stack.func_77978_p() == null;
    }

    protected static Set<BlockPos> findSuitableBlocks(ItemStack stack, World world, EnumFacing sideHit, BlockPos pos, Block centerBlock, int centerMeta) {
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>();
        int mode = stack.func_77978_p().func_74762_e("mode");
        int dim = 0;
        switch (mode) {
            case 0: {
                dim = 0;
                break;
            }
            case 1: {
                dim = 1;
                break;
            }
            case 2: {
                dim = 2;
                break;
            }
            case 3: {
                dim = 3;
                break;
            }
            case 4: {
                dim = 4;
                break;
            }
            case 5: {
                dim = 5;
                break;
            }
            case 6: {
                dim = 6;
                break;
            }
            case 7: {
                dim = 7;
                break;
            }
            case 8: {
                dim = 8;
                break;
            }
            case 9: {
                dim = 9;
                break;
            }
            case 10: {
                dim = 10;
                break;
            }
            case 11: {
                dim = 11;
                break;
            }
            case 12: {
                dim = 12;
            }
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        switch (sideHit) {
            case UP: 
            case DOWN: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        ExchangerHandler.checkAndAddBlock(world, dx, y, dz, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
            case SOUTH: 
            case NORTH: {
                for (int dx = x - dim; dx <= x + dim; ++dx) {
                    for (int dy = y - dim; dy <= y + dim; ++dy) {
                        ExchangerHandler.checkAndAddBlock(world, dx, dy, z, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
            case EAST: 
            case WEST: {
                for (int dy = y - dim; dy <= y + dim; ++dy) {
                    for (int dz = z - dim; dz <= z + dim; ++dz) {
                        ExchangerHandler.checkAndAddBlock(world, x, dy, dz, centerBlock, centerMeta, coordinates);
                    }
                }
                break;
            }
        }
        return coordinates;
    }

    private static void checkAndAddBlock(World world, int x, int y, int z, Block centerBlock, int centerMeta, Set<BlockPos> coordinates) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == centerBlock && state.func_177230_c().func_176201_c(state) == centerMeta) {
            coordinates.add(pos);
        }
    }

    private static int findItem(Item item, int meta, InventoryPlayer inv) {
        for (int i = 0; i < 36; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (!StackUtil.isValid(stack) || stack.func_77973_b() != item || meta != stack.func_77952_i()) continue;
            return i;
        }
        return -1;
    }

    private static void giveItem(World world, EntityPlayer player, BlockPos pos, ItemStack oldStack) {
        if (!player.field_71071_by.func_70441_a(oldStack)) {
            EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), oldStack);
            world.func_72838_d((Entity)entityItem);
        }
    }

    protected static NBTTagCompound getTagCompound(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        return tagCompound;
    }

    private static String getBlockName(Block block, int meta) {
        ItemStack stack = new ItemStack(block, 1, meta);
        if (stack == ItemStack.field_190927_a) {
            return null;
        }
        return stack.func_82833_r();
    }

    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.getShiftText());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (ExchangerHandler.stackTagCompoundNull(stack)) {
            ExchangerHandler.setDefaultTagCompound(stack);
        }
        NBTTagCompound compound = stack.func_77978_p();
        ItemExchanger exchanger = (ItemExchanger)stack.func_77973_b();
        if (compound == null || compound.func_74762_e("block") == 0) {
            tooltip.add(StringHelper.localize("tooltip.noselectedblock", new Object[0]));
        } else {
            int id = compound.func_74762_e("block");
            Block block = Block.func_149729_e((int)id);
            int meta = compound.func_74762_e("meta");
            tooltip.add(StringHelper.localize("tooltip.selectedblock", new Object[0]) + " " + ExchangerHandler.getBlockName(block, meta));
            tooltip.add(StringHelper.localize("tooltip.currentrange", new Object[0]) + " " + modeSwitchList[compound.func_74762_e("mode")]);
            tooltip.add(StringHelper.localize("tooltip.maxrange", new Object[0]) + " " + modeSwitchList[exchanger.getTier().getMaxSize()]);
        }
        if (StringHelper.isShiftKeyDown()) {
            tooltip.remove(StringHelper.getShiftText());
            tooltip.add(StringHelper.localize("tooltip.shift1", new Object[0]));
            tooltip.add(StringHelper.localize("tooltip.shift2", new Object[0]));
            tooltip.add(StringHelper.localize("tooltip.shift3", new Object[0]) + " (" + Keys.MODE_KEY.getDisplayName() + ")");
        }
    }

    public boolean isCreative() {
        return false;
    }

    public boolean isPowered() {
        return false;
    }

    public void switchMode(EntityPlayer player, ItemStack stack) {
        if (ExchangerHandler.stackTagCompoundNull(stack)) {
            ExchangerHandler.setDefaultTagCompound(stack);
        }
        int modeSwitch = stack.func_77978_p().func_74762_e("mode");
        ItemStack heldItem = player.func_184614_ca();
        ItemExchanger exchanger = (ItemExchanger)stack.func_77973_b();
        if (heldItem != null && ++modeSwitch > exchanger.getTier().getMaxSize()) {
            modeSwitch = 0;
        }
        stack.func_77978_p().func_74768_a("mode", modeSwitch);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                this.selectBlock(player.func_184586_b(hand), player, world, pos);
            } else {
                this.placeBlock(player.func_184586_b(hand), player, world, pos, side);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void placeBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        int id = tagCompound.func_74762_e("block");
        Block block = (Block)Block.field_149771_c.func_148754_a(id);
        int meta = tagCompound.func_74762_e("meta");
        IBlockState oldState = world.func_180495_p(pos);
        Block oldblock = oldState.func_177230_c();
        int oldmeta = oldblock.func_176201_c(oldState);
        float blockHardness = oldblock.func_176195_g(oldState, world, pos);
        if (block == oldblock && meta == oldmeta) {
            return;
        }
        if (world.func_175625_s(pos) != null) {
            ChatHelper.msgPlayer(player, StringHelper.localize("error.invalidblock", new Object[0]));
            return;
        }
        if (blockHardness < -0.1f && !this.isCreative()) {
            ChatHelper.msgPlayer(player, StringHelper.localize("error.invalidblock", new Object[0]));
            return;
        }
        if (stack.func_77973_b() instanceof ItemPoweredExchanger) {
            ItemPoweredExchanger powered = (ItemPoweredExchanger)stack.func_77973_b();
            if (this.isPowered() && stack.func_77978_p().func_74762_e("Energy") < powered.getPerBlockCost() && !this.isCreative()) {
                ChatHelper.msgPlayer(player, StringHelper.localize("error.nopower", new Object[0]));
                return;
            }
        }
        Set<BlockPos> coordinates = ExchangerHandler.findSuitableBlocks(stack, world, side, pos, oldblock, oldmeta);
        boolean notEnough = false;
        for (BlockPos coordinate : coordinates) {
            if (this.consumeItemInInventory(Item.func_150898_a((Block)block), meta, player.field_71071_by, player)) {
                if (!player.field_71075_bZ.field_75098_d && !this.isCreative()) {
                    ItemStack oldblockItem = oldblock.func_185473_a(world, pos, oldState);
                    ExchangerHandler.giveItem(world, player, pos, oldblockItem);
                    if (!this.isPowered() && !this.isCreative()) {
                        stack.func_77972_a(1, (EntityLivingBase)player);
                    }
                    if (stack.func_77973_b() instanceof ItemPoweredExchanger) {
                        ItemPoweredExchanger powered = (ItemPoweredExchanger)stack.func_77973_b();
                        if (stack.func_77978_p().func_74762_e("Energy") >= powered.getPerBlockCost()) {
                            stack.func_77978_p().func_74768_a("Energy", stack.func_77978_p().func_74762_e("Energy") - powered.getPerBlockCost());
                        }
                    }
                }
                world.func_184148_a(null, (double)coordinate.func_177958_n(), (double)coordinate.func_177956_o(), (double)coordinate.func_177952_p(), SoundEvents.field_187534_aX, SoundCategory.BLOCKS, 0.1f, 1.0f);
                world.func_180501_a(coordinate, block.func_176203_a(meta), 3);
                player.field_71070_bA.func_75142_b();
                continue;
            }
            notEnough = true;
        }
        if (notEnough) {
            ChatHelper.msgPlayer(player, StringHelper.localize("error.outofblock", new Object[0]));
        }
    }

    private void selectBlock(ItemStack stack, EntityPlayer player, World world, BlockPos pos) {
        if (ExchangerHandler.stackTagCompoundNull(stack)) {
            ExchangerHandler.setDefaultTagCompound(stack);
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        NBTTagCompound tagCompound = ExchangerHandler.getTagCompound(stack);
        String name = ExchangerHandler.getBlockName(block, meta);
        float blockHardness = block.func_176195_g(state, world, pos);
        if (name == null) {
            ChatHelper.msgPlayer(player, StringHelper.localize("error.invalidblock", new Object[0]));
        } else if (world.func_175625_s(pos) != null) {
            ChatHelper.msgPlayer(player, StringHelper.localize("error.invalidblock", new Object[0]));
        } else if (blockHardness < -0.1f) {
            if (!this.isCreative()) {
                ChatHelper.msgPlayer(player, StringHelper.localize("error.invalidblock", new Object[0]));
            }
        } else {
            int id = Block.field_149771_c.func_148757_b((Object)block);
            tagCompound.func_74768_a("block", id);
            tagCompound.func_74768_a("meta", meta);
        }
    }

    private boolean consumeItemInInventory(Item item, int meta, InventoryPlayer inv, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d || this.isCreative()) {
            return true;
        }
        int i = ExchangerHandler.findItem(item, meta, inv);
        if (i < 0) {
            return false;
        }
        ItemStack stackInSlot = inv.func_70301_a(i);
        if (StackUtil.getStackSize(stackInSlot = StackUtil.incStackSize(stackInSlot, -1)) == 0) {
            inv.func_70299_a(i, StackUtil.getEmptyStack(new ItemStack(item)));
        }
        return true;
    }
}

