/*
 * Decompiled with CFR 0.152.
 */
package me.jacky1356400.exchangers.item;

import cofh.redstoneflux.api.IEnergyContainerItem;
import cofh.redstoneflux.util.EnergyContainerItemWrapper;
import java.util.List;
import me.jacky1356400.exchangers.helper.EnergyHelper;
import me.jacky1356400.exchangers.helper.NBTHelper;
import me.jacky1356400.exchangers.helper.StringHelper;
import me.jacky1356400.exchangers.item.ItemExchanger;
import me.jacky1356400.exchangers.util.Tier;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemPoweredExchanger
extends ItemExchanger
implements IEnergyContainerItem {
    private final int maxEnergy;
    private final int perBlockUse;

    public ItemPoweredExchanger(String name, Tier tier, int maxStorage, int perBlock) {
        super(name, true, tier, 0);
        this.maxEnergy = maxStorage;
        this.perBlockUse = perBlock;
    }

    public int receiveEnergy(ItemStack container, int energy, boolean simulate) {
        return NBTHelper.receiveEnergy(container, energy, this.getMaxEnergyStored(container), simulate);
    }

    public int extractEnergy(ItemStack container, int energy, boolean simulate) {
        return NBTHelper.extractEnergy(container, energy, simulate);
    }

    public int getEnergyStored(ItemStack container) {
        return NBTHelper.getEnergyStored(container);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    public int getPerBlockCost() {
        return this.perBlockUse;
    }

    @Override
    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag(stack, 0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.getMaxEnergyStored(stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(StringHelper.formatNumber(this.getEnergyStored(stack)) + " / " + StringHelper.formatNumber(this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add(this.getTier().getFormattedText());
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    @Override
    public boolean isPowered() {
        return true;
    }

    @Override
    public boolean isCreative() {
        return false;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            ItemStack empty = new ItemStack((Item)this);
            list.add((Object)empty);
            ItemStack full = new ItemStack((Item)this);
            EnergyHelper.setDefaultEnergyTag(full, this.maxEnergy);
            list.add((Object)full);
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this);
    }
}

