/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.book.data.element;

import com.google.gson.JsonObject;
import net.minecraft.block.Block;
import net.minecraft.command.CommandGive;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import slimeknights.mantle.client.book.BookLoader;
import slimeknights.mantle.client.book.repository.BookRepository;

public class ItemStackData {
    public String itemList = null;
    public transient BookRepository source;
    public transient ResourceLocation itemListLocation = null;
    public transient String action;
    public String id = "";
    public byte amount = 1;
    public short damage = 0;
    public JsonObject nbt;

    public NonNullList<ItemStack> getItems() {
        if (this.itemListLocation != null && this.source.resourceExists(this.itemListLocation)) {
            try {
                ItemsList itemsList = (ItemsList)BookLoader.GSON.fromJson(this.source.resourceToString(this.source.getResource(this.itemListLocation)), ItemsList.class);
                NonNullList items = NonNullList.func_191197_a((int)itemsList.items.length, (Object)ItemStack.field_190927_a);
                for (int i = 0; i < itemsList.items.length; ++i) {
                    items.set(i, (Object)itemsList.items[i].getItem());
                }
                this.action = itemsList.action;
                return items;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NonNullList.func_191197_a((int)1, (Object)this.getItem());
    }

    private ItemStack getItem() {
        Item item;
        boolean isMissingItem = false;
        try {
            item = CommandGive.func_147179_f(null, (String)this.id);
        }
        catch (NumberInvalidException e) {
            item = Item.func_150898_a((Block)Blocks.field_180401_cv);
            isMissingItem = true;
        }
        if (item == Items.field_190931_a) {
            item = Item.func_150898_a((Block)Blocks.field_180401_cv);
            isMissingItem = true;
        }
        ItemStack itemStack = new ItemStack(item, (int)this.amount, (int)this.damage);
        if (this.nbt != null) {
            try {
                itemStack.func_77982_d(JsonToNBT.func_180713_a((String)ItemStackData.filterJsonQuotes(this.nbt.toString())));
            }
            catch (NBTException nBTException) {
                // empty catch block
            }
        }
        if (isMissingItem) {
            NBTTagCompound display = itemStack.func_179543_a("display");
            display.func_74778_a("Name", "\u00a7rUnknown Item");
            NBTTagList lore = new NBTTagList();
            lore.func_74742_a((NBTBase)new NBTTagString("\u00a7r\u00a7eItem Name:"));
            lore.func_74742_a((NBTBase)new NBTTagString("\u00a7r\u00a7e" + this.id));
            display.func_74782_a("Lore", (NBTBase)lore);
        }
        return itemStack;
    }

    public static ItemStackData getItemStackData(ItemStack stack) {
        return ItemStackData.getItemStackData(stack, false);
    }

    public static ItemStackData getItemStackData(ItemStack stack, boolean ignoreNbt) {
        ItemStackData data = new ItemStackData();
        data.id = ((ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())).toString();
        data.amount = (byte)stack.func_190916_E();
        data.damage = (short)stack.func_77952_i();
        if (!ignoreNbt && stack.func_77978_p() != null) {
            data.nbt = BookLoader.GSON.toJsonTree((Object)stack.func_77978_p(), NBTTagCompound.class).getAsJsonObject();
        }
        return data;
    }

    public static String filterJsonQuotes(String s) {
        return s.replaceAll("\"(\\w+)\"\\s*:", "$1: ");
    }

    public static class ItemLink {
        public ItemStackData item = new ItemStackData();
        public boolean damageSensitive = false;
        public String action = "";
    }

    private static class ItemsList {
        public ItemStackData[] items = new ItemStackData[0];
        public String action;

        private ItemsList() {
        }
    }
}

