/*
 * Decompiled with CFR 0.152.
 */
package tehnut.xtones.block;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import tehnut.xtones.Xtones;
import tehnut.xtones.block.BlockEnum;

public class BlockLamp
extends BlockEnum<EnumFacing> {
    public static final IProperty<Boolean> ACTIVE = PropertyBool.func_177716_a((String)"active");
    private final LampShape shape;

    public BlockLamp(LampShape shape) {
        super(Material.field_151592_s, EnumFacing.class, "facing");
        this.shape = shape;
        this.func_149663_c("xtones.lamp." + shape.func_176610_l());
        this.func_149647_a(Xtones.TAB);
        this.func_180632_j(this.func_176223_P().func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
    }

    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b(ACTIVE) != false ? 15 : 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess access, IBlockState state, BlockPos pos, EnumFacing facing) {
        return state.func_177229_b(this.getProperty()) == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.shape.getBound((EnumFacing)state.func_177229_b(this.getProperty()));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(false)), 2);
        } else if (!((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && world.func_175640_z(pos)) {
            world.func_180501_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(true)), 2);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175684_a(pos, (Block)this, 4);
        } else if (!((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && world.func_175640_z(pos)) {
            world.func_175656_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(true)));
        }
        EnumFacing facing = (EnumFacing)state.func_177229_b(this.getProperty());
        BlockPos reversePos = pos.func_177972_a(facing.func_176734_d());
        if (!world.isSideSolid(reversePos, facing, false)) {
            world.func_175698_g(pos);
            this.func_176226_b(world, pos, state, 0);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (((Boolean)state.func_177229_b(ACTIVE)).booleanValue() && !world.func_175640_z(pos)) {
            world.func_175656_a(pos, state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(this.getProperty(), (Comparable)facing);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldAccess, BlockPos pos) {
        World world;
        if (worldAccess instanceof ChunkCache && (world = (World)ReflectionHelper.getPrivateValue(ChunkCache.class, (Object)((ChunkCache)worldAccess), (String[])new String[]{"field_72815_e", "world"})).func_175640_z(pos)) {
            return state.func_177226_a(ACTIVE, (Comparable)Boolean.valueOf(true));
        }
        return super.func_176221_a(state, worldAccess, pos);
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> subBlocks) {
        subBlocks.add((Object)new ItemStack((Block)this));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    @Override
    protected BlockStateContainer createStateContainer() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{this.getProperty(), ACTIVE}).build();
    }

    public static class Shapes {
        public static final AxisAlignedBB FLAT_UP = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
        public static final AxisAlignedBB FLAT_DOWN = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB FLAT_NORTH = new AxisAlignedBB(0.0, 0.0, 0.8125, 1.0, 1.0, 1.0);
        public static final AxisAlignedBB FLAT_EAST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.1875, 1.0, 1.0);
        public static final AxisAlignedBB FLAT_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.1875);
        public static final AxisAlignedBB FLAT_WEST = new AxisAlignedBB(0.8125, 0.0, 0.0, 1.0, 1.0, 1.0);
    }

    public static enum LampShape implements IStringSerializable
    {
        FLAT(Shapes.FLAT_UP, Shapes.FLAT_DOWN, Shapes.FLAT_NORTH, Shapes.FLAT_EAST, Shapes.FLAT_SOUTH, Shapes.FLAT_WEST);

        private final EnumMap<EnumFacing, AxisAlignedBB> boundings = Maps.newEnumMap(EnumFacing.class);

        private LampShape(@Nonnull AxisAlignedBB boundUp, @Nonnull AxisAlignedBB boundDown, @Nonnull AxisAlignedBB boundNorth, @Nonnull AxisAlignedBB boundEast, AxisAlignedBB boundSouth, AxisAlignedBB boundWest) {
            this.boundings.put(EnumFacing.UP, boundUp);
            this.boundings.put(EnumFacing.DOWN, boundDown);
            this.boundings.put(EnumFacing.NORTH, boundNorth);
            this.boundings.put(EnumFacing.EAST, boundEast);
            this.boundings.put(EnumFacing.SOUTH, boundSouth);
            this.boundings.put(EnumFacing.WEST, boundWest);
        }

        @Nonnull
        public AxisAlignedBB getBound(EnumFacing facing) {
            return this.boundings.get(facing);
        }

        @Nonnull
        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

