/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.misc;

import appeng.api.util.IOrientable;
import appeng.api.util.IOrientableBlock;
import appeng.block.AEBaseTileBlock;
import appeng.helpers.ICustomCollision;
import appeng.helpers.MetaRotation;
import appeng.tile.misc.TileLightDetector;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLightDetector
extends AEBaseTileBlock
implements IOrientableBlock,
ICustomCollision {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    public static final PropertyBool ODD = PropertyBool.func_177716_a((String)"odd");

    public BlockLightDetector() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)ODD, (Comparable)Boolean.valueOf(false)));
        this.func_149713_g(0);
        this.setFullSize(false);
        this.setOpaque(false);
        this.setTileEntity(TileLightDetector.class);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.values()[meta];
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{FACING, ODD};
    }

    public int func_180656_a(IBlockState state, IBlockAccess w, BlockPos pos, EnumFacing side) {
        if (w instanceof World && ((TileLightDetector)this.getTileEntity(w, pos)).isReady()) {
            return ((World)w).func_175671_l(pos) - 6;
        }
        return 0;
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(world, pos, neighbor);
        TileLightDetector tld = (TileLightDetector)this.getTileEntity(world, pos);
        if (tld != null) {
            tld.updateLight();
        }
    }

    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
    }

    @Override
    public boolean isValidOrientation(World w, BlockPos pos, EnumFacing forward, EnumFacing up) {
        return this.canPlaceAt(w, pos, up.func_176734_d());
    }

    private boolean canPlaceAt(World w, BlockPos pos, EnumFacing dir) {
        return w.isSideSolid(pos.func_177972_a(dir), dir.func_176734_d(), false);
    }

    @Override
    public Iterable<AxisAlignedBB> getSelectedBoundingBoxesFromPool(World w, BlockPos pos, Entity thePlayer, boolean b) {
        EnumFacing up = this.getOrientable((IBlockAccess)w, pos).getUp();
        double xOff = -0.3 * (double)up.func_82601_c();
        double yOff = -0.3 * (double)up.func_96559_d();
        double zOff = -0.3 * (double)up.func_82599_e();
        return Collections.singletonList(new AxisAlignedBB(xOff + 0.3, yOff + 0.3, zOff + 0.3, xOff + 0.7, yOff + 0.7, zOff + 0.7));
    }

    @Override
    public void addCollidingBlockToList(World w, BlockPos pos, AxisAlignedBB bb, List<AxisAlignedBB> out, Entity e) {
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        EnumFacing up = this.getOrientable((IBlockAccess)world, pos).getUp();
        if (!this.canPlaceAt(world, pos, up.func_176734_d())) {
            this.dropTorch(world, pos);
        }
    }

    private void dropTorch(World w, BlockPos pos) {
        IBlockState prev = w.func_180495_p(pos);
        w.func_175655_b(pos, true);
        w.func_184138_a(pos, prev, w.func_180495_p(pos), 3);
    }

    public boolean func_176196_c(World w, BlockPos pos) {
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (!this.canPlaceAt(w, pos, dir)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean usesMetadata() {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    public IOrientable getOrientable(IBlockAccess w, BlockPos pos) {
        return new MetaRotation(w, pos, (IProperty<EnumFacing>)FACING);
    }
}

