/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.qnb;

import appeng.block.AEBaseTileBlock;
import appeng.block.qnb.QnbFormedState;
import appeng.block.qnb.QnbFormedStateProperty;
import appeng.helpers.ICustomCollision;
import appeng.tile.qnb.TileQuantumBridge;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public abstract class BlockQuantumBase
extends AEBaseTileBlock
implements ICustomCollision {
    public static final PropertyBool FORMED = PropertyBool.func_177716_a((String)"formed");
    public static final QnbFormedStateProperty FORMED_STATE = new QnbFormedStateProperty();

    public BlockQuantumBase(Material mat) {
        super(mat);
        this.setTileEntity(TileQuantumBridge.class);
        float shave = 0.125f;
        this.boundingBox = new AxisAlignedBB(0.125, 0.125, 0.125, 0.875, 0.875, 0.875);
        this.func_149713_g(0);
        this.setFullSize(this.setOpaque(false));
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected IProperty[] getAEStates() {
        return new IProperty[]{FORMED};
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, this.getAEStates(), new IUnlistedProperty[]{FORMED_STATE});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extState = (IExtendedBlockState)state;
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity(world, pos);
        if (bridge != null) {
            QnbFormedState formedState = new QnbFormedState(bridge.getAdjacentQuantumBridges(), bridge.isCorner(), bridge.isPowered());
            extState = extState.withProperty((IUnlistedProperty)FORMED_STATE, (Object)formedState);
        }
        return extState;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity(worldIn, pos);
        if (bridge != null) {
            state = state.func_177226_a((IProperty)FORMED, (Comparable)Boolean.valueOf(bridge.isFormed()));
        }
        return state;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)world, pos);
        if (bridge != null) {
            bridge.neighborUpdate();
        }
    }

    @Override
    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        TileQuantumBridge bridge = (TileQuantumBridge)this.getTileEntity((IBlockAccess)w, pos);
        if (bridge != null) {
            bridge.breakCluster();
        }
        super.func_180663_b(w, pos, state);
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }
}

