/*
 * Decompiled with CFR 0.152.
 */
package appeng.block.storage;

import appeng.api.AEApi;
import appeng.api.util.AEPartLocation;
import appeng.block.AEBaseTileBlock;
import appeng.block.storage.DriveSlotsState;
import appeng.client.UnlistedProperty;
import appeng.client.render.FacingToRotation;
import appeng.core.AELog;
import appeng.core.sync.GuiBridge;
import appeng.tile.storage.TileDrive;
import appeng.util.Platform;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class BlockDrive
extends AEBaseTileBlock {
    public static final UnlistedProperty<DriveSlotsState> SLOTS_STATE = new UnlistedProperty<DriveSlotsState>("drive_slots_state", DriveSlotsState.class);

    public BlockDrive() {
        super(Material.field_151573_f);
        this.setTileEntity(TileDrive.class);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new ExtendedBlockState((Block)this, this.getAEStates(), new IUnlistedProperty[]{SLOTS_STATE, FORWARD, UP});
    }

    @Override
    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileDrive te = (TileDrive)this.getTileEntity(world, pos);
        if (te == null) {
            AELog.warn("Could not get TE for drive at %s, world is %s", pos.toString(), world.getClass().getName());
            return super.getExtendedState(state, world, pos);
        }
        IExtendedBlockState extState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        return extState.withProperty(SLOTS_STATE, (Object)DriveSlotsState.fromChestOrDrive(te));
    }

    private Vector3f rotateHitByFacing(float x, float y, float z, EnumFacing front, EnumFacing up) {
        Vector3f coord = new Vector3f(x, y, z);
        Matrix4f transform = FacingToRotation.get(front, up).getMat();
        transform.invert();
        transform.transform(coord);
        if (coord.x < 0.0f) {
            coord.x += 1.0f;
        }
        if (coord.y < 0.0f) {
            coord.y += 1.0f;
        }
        return new Vector3f(coord.x, coord.y, coord.z);
    }

    @Override
    public boolean onActivated(World w, BlockPos pos, EntityPlayer p, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileDrive tg = (TileDrive)this.getTileEntity((IBlockAccess)w, pos);
        if (tg != null) {
            Vector3f mapped = this.rotateHitByFacing(hitX, hitY, hitZ, tg.getForward(), tg.getUp());
            if (p.func_70093_af()) {
                if (!w.field_72995_K && p.func_184586_b(hand).func_190926_b() && side == tg.getForward()) {
                    return tg.tryAutoExtractDrive(mapped.x, mapped.y, p, hand);
                }
                return p.func_184586_b(hand).func_190926_b();
            }
            if (Platform.isServer() && (side != tg.getForward() || heldItem.func_190926_b() || !AEApi.instance().registries().cell().isCellHandled(heldItem) || !tg.tryAutoInsertDrive(mapped.x, mapped.y, heldItem, p, hand))) {
                Platform.openGUI(p, tg, AEPartLocation.fromFacing(side), GuiBridge.GUI_DRIVE);
            }
            return true;
        }
        return false;
    }
}

