/*
 * Decompiled with CFR 0.152.
 */
package appeng.bootstrap;

import appeng.bootstrap.FeatureFactory;
import appeng.bootstrap.IItemBuilder;
import appeng.bootstrap.ItemRendering;
import appeng.bootstrap.ItemRenderingCustomizer;
import appeng.bootstrap.components.RegistryComponent;
import appeng.core.AEConfig;
import appeng.core.CreativeTab;
import appeng.core.features.AEFeature;
import appeng.core.features.ItemDefinition;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.block.BlockDispenser;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

class ItemDefinitionBuilder
implements IItemBuilder {
    private final FeatureFactory factory;
    private final String registryName;
    private final Supplier<Item> itemSupplier;
    private final EnumSet<AEFeature> features = EnumSet.noneOf(AEFeature.class);
    private final List<Consumer<Item>> preInitCallbacks = new ArrayList<Consumer<Item>>();
    private final List<Consumer<Item>> initCallbacks = new ArrayList<Consumer<Item>>();
    private final List<Consumer<Item>> postInitCallbacks = new ArrayList<Consumer<Item>>();
    private Supplier<IBehaviorDispenseItem> dispenserBehaviorSupplier;
    @SideOnly(value=Side.CLIENT)
    private ItemRendering itemRendering;
    private CreativeTabs creativeTab = CreativeTab.instance;

    ItemDefinitionBuilder(FeatureFactory factory, String registryName, Supplier<Item> itemSupplier) {
        this.factory = factory;
        this.registryName = registryName;
        this.itemSupplier = itemSupplier;
        if (Platform.isClient()) {
            this.itemRendering = new ItemRendering();
        }
    }

    @Override
    public ItemDefinitionBuilder preInit(Consumer<Item> callback) {
        this.preInitCallbacks.add(callback);
        return this;
    }

    @Override
    public ItemDefinitionBuilder init(Consumer<Item> callback) {
        this.initCallbacks.add(callback);
        return this;
    }

    @Override
    public ItemDefinitionBuilder postInit(Consumer<Item> callback) {
        this.postInitCallbacks.add(callback);
        return this;
    }

    @Override
    public IItemBuilder features(AEFeature ... features) {
        this.features.clear();
        this.addFeatures(features);
        return this;
    }

    @Override
    public IItemBuilder addFeatures(AEFeature ... features) {
        Collections.addAll(this.features, features);
        return this;
    }

    @Override
    public IItemBuilder creativeTab(CreativeTabs tab) {
        this.creativeTab = tab;
        return this;
    }

    @Override
    public IItemBuilder rendering(ItemRenderingCustomizer callback) {
        if (Platform.isClient()) {
            this.customizeForClient(callback);
        }
        return this;
    }

    @Override
    public IItemBuilder dispenserBehavior(Supplier<IBehaviorDispenseItem> behavior) {
        this.dispenserBehaviorSupplier = behavior;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    private void customizeForClient(ItemRenderingCustomizer callback) {
        callback.customize(this.itemRendering);
    }

    @Override
    public ItemDefinition build() {
        if (!AEConfig.instance().areFeaturesEnabled(this.features)) {
            return new ItemDefinition(this.registryName, null);
        }
        final Item item = this.itemSupplier.get();
        item.setRegistryName("appliedenergistics2", this.registryName);
        ItemDefinition definition = new ItemDefinition(this.registryName, item);
        item.func_77655_b("appliedenergistics2." + this.registryName);
        item.func_77637_a(this.creativeTab);
        this.preInitCallbacks.forEach(consumer -> this.factory.addPreInit(side -> consumer.accept(item)));
        this.initCallbacks.forEach(consumer -> this.factory.addInit(side -> consumer.accept(item)));
        this.postInitCallbacks.forEach(consumer -> this.factory.addPostInit(side -> consumer.accept(item)));
        if (this.dispenserBehaviorSupplier != null) {
            this.factory.addPostInit(side -> {
                IBehaviorDispenseItem behavior = this.dispenserBehaviorSupplier.get();
                BlockDispenser.field_149943_a.func_82595_a((Object)item, (Object)behavior);
            });
        }
        this.factory.addRegistry(new RegistryComponent(){

            @Override
            public <T extends IForgeRegistryEntry<T>> void registryEvent(IForgeRegistry<T> registry, Class<T> clazz) {
                if (clazz == Item.class && item != null) {
                    registry.register((IForgeRegistryEntry)item);
                }
            }
        });
        if (Platform.isClient()) {
            this.itemRendering.apply(this.factory, item);
        }
        return definition;
    }
}

