/*
 * Decompiled with CFR 0.152.
 */
package appeng.client;

import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.capabilities.Capabilities;
import appeng.client.EffectType;
import appeng.client.render.effects.AssemblerFX;
import appeng.client.render.effects.CraftingFx;
import appeng.client.render.effects.EnergyFx;
import appeng.client.render.effects.LightningArcFX;
import appeng.client.render.effects.LightningFX;
import appeng.client.render.effects.VibrantFX;
import appeng.client.render.model.UVLModelLoader;
import appeng.client.render.tesr.InscriberTESR;
import appeng.client.render.textures.ParticleTextures;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.AppEng;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.core.sync.packets.PacketBaubleTerminalKey;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.coremod.MissingCoreMod;
import appeng.entity.EntityFloatingItem;
import appeng.entity.EntityTinyTNTPrimed;
import appeng.entity.RenderFloatingItem;
import appeng.entity.RenderTinyTNTPrimed;
import appeng.helpers.IMouseWheelItem;
import appeng.hooks.TickHandler;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.server.ServerHelper;
import appeng.util.Platform;
import baubles.api.cap.IBaublesItemHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;

public class ClientHelper
extends ServerHelper {
    private static KeyBinding terminalKey;

    @Override
    public void preinit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (!FMLClientHandler.instance().hasOptifine() && ForgeModContainer.forgeLightPipelineEnabled) {
            ModelLoaderRegistry.registerLoader((ICustomModelLoader)UVLModelLoader.INSTANCE);
        }
    }

    @Override
    public void init() {
        if (Loader.isModLoaded((String)"baubles")) {
            terminalKey = new KeyBinding("key.appliedenergistics2.terminal", 0, "itemGroup.appliedenergistics2");
            ClientRegistry.registerKeyBinding((KeyBinding)terminalKey);
        }
    }

    @Override
    public World getWorld() {
        if (Platform.isClient()) {
            return Minecraft.func_71410_x().field_71441_e;
        }
        return super.getWorld();
    }

    @Override
    public void bindTileEntitySpecialRenderer(Class<? extends TileEntity> tile, AEBaseBlock blk) {
    }

    @Override
    public List<EntityPlayer> getPlayers() {
        if (Platform.isClient()) {
            ArrayList<EntityPlayer> o = new ArrayList<EntityPlayer>();
            o.add((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            return o;
        }
        return super.getPlayers();
    }

    @Override
    public void spawnEffect(EffectType effect, World world, double posX, double posY, double posZ, Object o) {
        if (AEConfig.instance().isEnableEffects()) {
            switch (effect) {
                case Assembler: {
                    this.spawnAssembler(world, posX, posY, posZ, o);
                    return;
                }
                case Vibrant: {
                    this.spawnVibrant(world, posX, posY, posZ);
                    return;
                }
                case Crafting: {
                    this.spawnCrafting(world, posX, posY, posZ);
                    return;
                }
                case Energy: {
                    this.spawnEnergy(world, posX, posY, posZ);
                    return;
                }
                case Lightning: {
                    this.spawnLightning(world, posX, posY, posZ);
                    return;
                }
                case LightningArc: {
                    this.spawnLightningArc(world, posX, posY, posZ, (Vec3d)o);
                    return;
                }
            }
        }
    }

    @Override
    public boolean shouldAddParticles(Random r) {
        int setting = Minecraft.func_71410_x().field_71474_y.field_74362_aa;
        if (setting == 2) {
            return false;
        }
        if (setting == 0) {
            return true;
        }
        return r.nextInt(2 * (setting + 1)) == 0;
    }

    @Override
    public RayTraceResult getRTR() {
        return Minecraft.func_71410_x().field_71476_x;
    }

    @Override
    public void postInit() {
        RenderManager inst = Minecraft.func_71410_x().func_175598_ae();
        inst.field_78729_o.put(EntityTinyTNTPrimed.class, new RenderTinyTNTPrimed(inst));
        inst.field_78729_o.put(EntityFloatingItem.class, new RenderFloatingItem(inst));
    }

    @Override
    public CableRenderMode getRenderMode() {
        if (Platform.isServer()) {
            return super.getRenderMode();
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        return this.renderModeForPlayer((EntityPlayer)player);
    }

    @Override
    public void triggerUpdates() {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc == null || mc.field_71439_g == null || mc.field_71441_e == null) {
            return;
        }
        EntityPlayerSP player = mc.field_71439_g;
        int x = (int)player.field_70165_t;
        int y = (int)player.field_70163_u;
        int z = (int)player.field_70161_v;
        int range = 256;
        mc.field_71441_e.func_147458_c(x - 256, y - 256, z - 256, x + 256, y + 256, z + 256);
    }

    @Override
    public void missingCoreMod() {
        throw new MissingCoreMod();
    }

    @SubscribeEvent
    public void postPlayerRender(RenderLivingEvent.Pre p) {
        TickHandler.PlayerColor player = TickHandler.INSTANCE.getPlayerColors().get(p.getEntity().func_145782_y());
        if (player != null) {
            AEColor col = player.myColor;
            float r = 0xFF & col.mediumVariant >> 16;
            float g = 0xFF & col.mediumVariant >> 8;
            float b = 0xFF & col.mediumVariant;
            GlStateManager.func_179124_c((float)(r / 255.0f), (float)(g / 255.0f), (float)(b / 255.0f));
        }
    }

    private void spawnAssembler(World world, double posX, double posY, double posZ, Object o) {
        PacketAssemblerAnimation paa = (PacketAssemblerAnimation)o;
        AssemblerFX fx = new AssemblerFX(world, posX, posY, posZ, 0.0, 0.0, 0.0, paa.rate, paa.is);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnVibrant(World w, double x, double y, double z) {
        if (AppEng.proxy.shouldAddParticles(Platform.getRandom())) {
            double d0 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d1 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            double d2 = (double)(Platform.getRandomFloat() - 0.5f) * 0.26;
            VibrantFX fx = new VibrantFX(w, x + d0, y + d1, z + d2, 0.0, 0.0, 0.0);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
        }
    }

    private void spawnCrafting(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        CraftingFx fx = new CraftingFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.field_151045_i);
        fx.setMotionX(-x * 0.2f);
        fx.setMotionY(-y * 0.2f);
        fx.setMotionZ(-z * 0.2f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnEnergy(World w, double posX, double posY, double posZ) {
        float x = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float y = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        float z = (float)((double)(Platform.getRandomInt() % 100) * 0.01 - 0.5) * 0.7f;
        EnergyFx fx = new EnergyFx(w, posX + (double)x, posY + (double)y, posZ + (double)z, Items.field_151045_i);
        fx.setMotionX(-x * 0.1f);
        fx.setMotionY(-y * 0.1f);
        fx.setMotionZ(-z * 0.1f);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnLightning(World world, double posX, double posY, double posZ) {
        LightningFX fx = new LightningFX(world, posX, posY + (double)0.3f, posZ, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    private void spawnLightningArc(World world, double posX, double posY, double posZ, Vec3d second) {
        LightningArcFX fx = new LightningArcFX(world, posX, posY, posZ, second.field_72450_a, second.field_72448_b, second.field_72449_c, 0.0, 0.0, 0.0);
        Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)fx);
    }

    @SubscribeEvent
    public void wheelEvent(MouseEvent me) {
        if (me.getDwheel() == 0) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (player.func_70093_af()) {
            EnumHand hand;
            if (!player.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof IMouseWheelItem) {
                hand = EnumHand.MAIN_HAND;
            } else if (!player.func_184586_b(EnumHand.OFF_HAND).func_190926_b() && player.func_184586_b(EnumHand.OFF_HAND).func_77973_b() instanceof IMouseWheelItem) {
                hand = EnumHand.OFF_HAND;
            } else {
                return;
            }
            ItemStack is = player.func_184586_b(hand);
            try {
                NetworkHandler.instance().sendToServer(new PacketValueConfig("Item", me.getDwheel() > 0 ? "WheelUp" : "WheelDown"));
                me.setCanceled(true);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        ParticleTextures.registerSprite(event);
        InscriberTESR.registerTexture(event);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        IBaublesItemHandler handler;
        if (Capabilities.CAPABILITY_BAUBLES != null && terminalKey.func_151468_f() && (handler = (IBaublesItemHandler)Minecraft.func_71410_x().field_71439_g.getCapability(Capabilities.CAPABILITY_BAUBLES, null)) != null) {
            int slots = handler.getSlots();
            ItemStack term = ItemStack.field_190927_a;
            for (int slot = 0; slot < slots; ++slot) {
                ItemStack stack = handler.getStackInSlot(slot);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ToolWirelessTerminal)) continue;
                term = stack;
                break;
            }
            if (!term.func_190926_b()) {
                NetworkHandler.instance().sendToServer(new PacketBaubleTerminalKey());
            }
        }
    }
}

