/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.AEApi;
import appeng.api.config.SearchBoxMode;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.client.gui.widgets.GuiScrollbar;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.client.me.ClientDCInternalInv;
import appeng.client.me.SlotDisconnected;
import appeng.container.implementations.ContainerInterfaceTerminal;
import appeng.container.slot.AppEngSlot;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.integration.Integrations;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.util.Platform;
import com.google.common.collect.HashMultimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.lwjgl.input.Mouse;

public class GuiInterfaceTerminal
extends AEBaseGui {
    private static final int SECTION_HEIGHT = 18;
    private final int offsetX = 9;
    private final HashMap<Long, ClientDCInternalInv> byId = new HashMap();
    private final HashMultimap<String, ClientDCInternalInv> byName = HashMultimap.create();
    private final ArrayList<String> names = new ArrayList();
    private final ArrayList<Object> lines = new ArrayList();
    private final Map<String, Set<Object>> cachedSearches = new WeakHashMap<String, Set<Object>>();
    private boolean refreshList = false;
    private MEGuiTextField searchField;
    private int rows = 6;
    private GuiImgButton searchBoxSettings;
    private GuiImgButton terminalStyleBox;

    public GuiInterfaceTerminal(InventoryPlayer inventoryPlayer, PartInterfaceTerminal te) {
        super(new ContainerInterfaceTerminal(inventoryPlayer, te));
        GuiScrollbar scrollbar = new GuiScrollbar();
        this.setScrollBar(scrollbar);
        this.field_146999_f = 195;
        this.field_147000_g = 222;
    }

    protected void func_146284_a(GuiButton btn) throws IOException {
        super.func_146284_a(btn);
        if (btn instanceof GuiImgButton) {
            boolean backwards = Mouse.isButtonDown((int)1);
            GuiImgButton iBtn = (GuiImgButton)btn;
            if (iBtn.getSetting() != Settings.ACTIONS) {
                Enum cv = iBtn.getCurrentValue();
                Enum next = Platform.rotateEnum(cv, backwards, iBtn.getSetting().getPossibleValues());
                if (btn == this.terminalStyleBox || btn == this.searchBoxSettings) {
                    AEConfig.instance().getConfigManager().putSetting(iBtn.getSetting(), next);
                } else {
                    try {
                        NetworkHandler.instance().sendToServer(new PacketValueConfig(iBtn.getSetting().name(), next.name()));
                    }
                    catch (IOException e) {
                        AELog.debug(e);
                    }
                }
                iBtn.set(next);
                if (next.getClass() == SearchBoxMode.class || next.getClass() == TerminalStyle.class) {
                    this.reinitalize();
                }
            }
        }
    }

    private void reinitalize() {
        this.field_146292_n.clear();
        this.func_73866_w_();
        this.refreshList();
    }

    @Override
    public void func_73866_w_() {
        int staticSpace = 115;
        this.calculateRows(115);
        super.func_73866_w_();
        this.field_147000_g = 115 + this.rows * 18;
        int unusedSpace = this.field_146295_m - this.field_147000_g;
        this.field_147009_r = (int)Math.floor((float)unusedSpace / (unusedSpace < 0 ? 3.8f : 2.0f));
        int offset = this.field_147009_r + 8;
        this.getScrollBar().setLeft(175);
        this.getScrollBar().setHeight(this.rows * 18 - 2);
        this.getScrollBar().setTop(18);
        this.getScrollBar().setRange(0, this.lines.size() - this.rows, 2);
        this.searchBoxSettings = new GuiImgButton(this.field_147003_i - 18, offset, Settings.SEARCH_MODE, AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE));
        this.field_146292_n.add(this.searchBoxSettings);
        this.terminalStyleBox = new GuiImgButton(this.field_147003_i - 18, offset += 20, Settings.TERMINAL_STYLE, AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE));
        this.field_146292_n.add(this.terminalStyleBox);
        this.searchField = new MEGuiTextField(this.field_146289_q, this.field_147003_i + Math.max(104, this.offsetX), this.field_147009_r + 4, 65, 12);
        this.searchField.func_146185_a(false);
        this.searchField.func_146203_f(25);
        this.searchField.func_146193_g(0xFFFFFF);
        this.searchField.func_146189_e(true);
        this.searchField.func_146195_b(true);
        Enum<?> setting = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        this.searchField.func_146195_b(SearchBoxMode.AUTOSEARCH == setting || SearchBoxMode.JEI_AUTOSEARCH == setting);
        for (Object s : this.field_147002_h.field_75151_b) {
            if (!(s instanceof AppEngSlot) || ((Slot)s).field_75223_e >= 197) continue;
            this.repositionSlot((AppEngSlot)((Object)s));
        }
    }

    private void calculateRows(int height) {
        int maxRows = AEConfig.instance().getConfigManager().getSetting(Settings.TERMINAL_STYLE) == TerminalStyle.SMALL ? 6 : Integer.MAX_VALUE;
        double extraSpace = (double)this.field_146295_m - (double)height;
        this.rows = (int)Math.floor(extraSpace / 18.0);
        if (this.rows > maxRows) {
            this.rows = maxRows;
        }
        if (this.rows < 6) {
            this.rows = 6;
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(GuiText.InterfaceTerminal.getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
        int ex = this.getScrollBar().getCurrentScroll();
        Iterator o = this.field_147002_h.field_75151_b.iterator();
        while (o.hasNext()) {
            if (!(o.next() instanceof SlotDisconnected)) continue;
            o.remove();
        }
        int offset = 17;
        for (int x = 0; x < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                for (int z = 0; z < inv.getInventory().func_70302_i_(); ++z) {
                    this.field_147002_h.field_75151_b.add(new SlotDisconnected(inv, z, z * 18 + 8, 1 + offset));
                }
            } else if (lineObj instanceof String) {
                String name = (String)lineObj;
                int rows = this.byName.get((Object)name).size();
                if (rows > 1) {
                    name = name + " (" + rows + ')';
                }
                while (name.length() > 2 && this.field_146289_q.func_78256_a(name) > 155) {
                    name = name.substring(0, name.length() - 1);
                }
                this.field_146289_q.func_78276_b(name, 10, 6 + offset, 0x404040);
            }
            offset += 18;
        }
    }

    @Override
    protected void func_73864_a(int xCoord, int yCoord, int btn) throws IOException {
        Enum<?> searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        if (searchMode != SearchBoxMode.AUTOSEARCH && searchMode != SearchBoxMode.JEI_AUTOSEARCH) {
            this.searchField.func_146192_a(xCoord, yCoord, btn);
        }
        if (btn == 1 && this.searchField.isMouseIn(xCoord, yCoord)) {
            this.searchField.func_146180_a("");
            this.refreshList();
        }
        super.func_73864_a(xCoord, yCoord, btn);
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/interfaceterminal.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, 18);
        for (int x = 0; x < this.rows; ++x) {
            this.func_73729_b(offsetX, offsetY + 18 + x * 18, 0, 18, this.field_146999_f, 18);
        }
        this.func_73729_b(offsetX, offsetY + 18 + this.rows * 18 - 2, 0, 124, this.field_146999_f, 96);
        int offset = 17;
        int ex = this.getScrollBar().getCurrentScroll();
        for (int x = 0; x < this.rows && ex + x < this.lines.size(); ++x) {
            Object lineObj = this.lines.get(ex + x);
            if (lineObj instanceof ClientDCInternalInv) {
                ClientDCInternalInv inv = (ClientDCInternalInv)lineObj;
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                int width = inv.getInventory().func_70302_i_() * 18;
                this.func_73729_b(offsetX + 7, offsetY + offset, 7, 139, width, 18);
            }
            offset += 18;
        }
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
    }

    private void repositionSlot(AppEngSlot s) {
        s.field_75221_f = s.getY() + this.field_147000_g - 78 - 5;
    }

    protected void func_73869_a(char character, int key) throws IOException {
        if (!this.func_146983_a(key)) {
            if (character == ' ' && this.searchField.func_146179_b().isEmpty()) {
                return;
            }
            if (this.searchField.func_146201_a(character, key)) {
                this.refreshList();
            } else {
                super.func_73869_a(character, key);
            }
        }
    }

    public void postUpdate(NBTTagCompound in) {
        if (in.func_74767_n("clear")) {
            this.byId.clear();
            this.refreshList = true;
        }
        for (Object oKey : in.func_150296_c()) {
            String key = (String)oKey;
            if (!key.startsWith("=")) continue;
            try {
                long id = Long.parseLong(key.substring(1), 36);
                NBTTagCompound invData = in.func_74775_l(key);
                ClientDCInternalInv current = this.getById(id, invData.func_74763_f("sortBy"), invData.func_74779_i("un"));
                for (int x = 0; x < current.getInventory().func_70302_i_(); ++x) {
                    String which = Integer.toString(x);
                    if (!invData.func_74764_b(which)) continue;
                    current.getInventory().func_70299_a(x, new ItemStack(invData.func_74775_l(which)));
                }
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        if (this.refreshList) {
            this.refreshList = false;
            this.cachedSearches.clear();
            this.refreshList();
        }
    }

    private void refreshList() {
        this.byName.clear();
        Enum<?> searchMode = AEConfig.instance().getConfigManager().getSetting(Settings.SEARCH_MODE);
        if (searchMode == SearchBoxMode.JEI_AUTOSEARCH || searchMode == SearchBoxMode.JEI_MANUAL_SEARCH) {
            Integrations.jei().setSearchText(this.searchField.func_146179_b());
        }
        String searchFilterLowerCase = this.searchField.func_146179_b().toLowerCase();
        Set<Object> cachedSearch = this.getCacheForSearchTerm(searchFilterLowerCase);
        boolean rebuild = cachedSearch.isEmpty();
        for (ClientDCInternalInv entry : this.byId.values()) {
            if (!rebuild && !cachedSearch.contains(entry)) continue;
            boolean found = searchFilterLowerCase.isEmpty();
            if (!found && !searchFilterLowerCase.isEmpty()) {
                ItemStack itemStack;
                Iterator<ItemStack> iterator = entry.getInventory().iterator();
                while (iterator.hasNext() && !(found = this.itemStackMatchesSearchTerm(itemStack = iterator.next(), searchFilterLowerCase))) {
                }
            }
            if (found || entry.getName().toLowerCase().contains(searchFilterLowerCase)) {
                this.byName.put((Object)entry.getName(), (Object)entry);
                cachedSearch.add(entry);
                continue;
            }
            cachedSearch.remove(entry);
        }
        this.names.clear();
        this.names.addAll(this.byName.keySet());
        Collections.sort(this.names);
        this.lines.clear();
        this.lines.ensureCapacity(this.getMaxRows());
        for (String n : this.names) {
            this.lines.add(n);
            ArrayList clientInventories = new ArrayList();
            clientInventories.addAll(this.byName.get((Object)n));
            Collections.sort(clientInventories);
            this.lines.addAll(clientInventories);
        }
        this.getScrollBar().setRange(0, this.lines.size() - this.rows, 2);
    }

    private boolean itemStackMatchesSearchTerm(ItemStack itemStack, String searchTerm) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        NBTTagCompound encodedValue = itemStack.func_77978_p();
        if (encodedValue == null) {
            return false;
        }
        NBTTagList outTag = encodedValue.func_150295_c("out", 10);
        for (int i = 0; i < outTag.func_74745_c(); ++i) {
            String displayName;
            ItemStack parsedItemStack = new ItemStack(outTag.func_150305_b(i));
            if (parsedItemStack.func_190926_b() || !(displayName = Platform.getItemDisplayName(AEApi.instance().storage().createItemStack(parsedItemStack)).toLowerCase()).contains(searchTerm)) continue;
            return true;
        }
        return false;
    }

    private Set<Object> getCacheForSearchTerm(String searchTerm) {
        Set<Object> cache;
        if (!this.cachedSearches.containsKey(searchTerm)) {
            this.cachedSearches.put(searchTerm, new HashSet());
        }
        if ((cache = this.cachedSearches.get(searchTerm)).isEmpty() && searchTerm.length() > 1) {
            cache.addAll(this.getCacheForSearchTerm(searchTerm.substring(0, searchTerm.length() - 1)));
            return cache;
        }
        return cache;
    }

    private int getMaxRows() {
        return this.names.size() + this.byId.size();
    }

    private ClientDCInternalInv getById(long id, long sortBy, String string) {
        ClientDCInternalInv o = this.byId.get(id);
        if (o == null) {
            o = new ClientDCInternalInv(9, id, sortBy, string);
            this.byId.put(id, o);
            this.refreshList = true;
        }
        return o;
    }
}

