/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum FacingToRotation {
    DOWN_DOWN(new Vector3f(0.0f, 0.0f, 0.0f)),
    DOWN_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    DOWN_NORTH(new Vector3f(-90.0f, 0.0f, 0.0f)),
    DOWN_SOUTH(new Vector3f(-90.0f, 0.0f, 180.0f)),
    DOWN_WEST(new Vector3f(-90.0f, 0.0f, 90.0f)),
    DOWN_EAST(new Vector3f(-90.0f, 0.0f, -90.0f)),
    UP_DOWN(new Vector3f(0.0f, 0.0f, 0.0f)),
    UP_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    UP_NORTH(new Vector3f(90.0f, 0.0f, 180.0f)),
    UP_SOUTH(new Vector3f(90.0f, 0.0f, 0.0f)),
    UP_WEST(new Vector3f(90.0f, 0.0f, 90.0f)),
    UP_EAST(new Vector3f(90.0f, 0.0f, -90.0f)),
    NORTH_DOWN(new Vector3f(0.0f, 0.0f, 180.0f)),
    NORTH_UP(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_NORTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_SOUTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    NORTH_WEST(new Vector3f(0.0f, 0.0f, 90.0f)),
    NORTH_EAST(new Vector3f(0.0f, 0.0f, -90.0f)),
    SOUTH_DOWN(new Vector3f(0.0f, 180.0f, 180.0f)),
    SOUTH_UP(new Vector3f(0.0f, 180.0f, 0.0f)),
    SOUTH_NORTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH_SOUTH(new Vector3f(0.0f, 0.0f, 0.0f)),
    SOUTH_WEST(new Vector3f(0.0f, 180.0f, -90.0f)),
    SOUTH_EAST(new Vector3f(0.0f, 180.0f, 90.0f)),
    WEST_DOWN(new Vector3f(0.0f, 90.0f, 180.0f)),
    WEST_UP(new Vector3f(0.0f, 90.0f, 0.0f)),
    WEST_NORTH(new Vector3f(0.0f, 90.0f, -90.0f)),
    WEST_SOUTH(new Vector3f(0.0f, 90.0f, 90.0f)),
    WEST_WEST(new Vector3f(0.0f, 0.0f, 0.0f)),
    WEST_EAST(new Vector3f(0.0f, 0.0f, 0.0f)),
    EAST_DOWN(new Vector3f(0.0f, -90.0f, 180.0f)),
    EAST_UP(new Vector3f(0.0f, -90.0f, 0.0f)),
    EAST_NORTH(new Vector3f(0.0f, -90.0f, 90.0f)),
    EAST_SOUTH(new Vector3f(0.0f, -90.0f, -90.0f)),
    EAST_WEST(new Vector3f(0.0f, 0.0f, 0.0f)),
    EAST_EAST(new Vector3f(0.0f, 0.0f, 0.0f));

    private final Vector3f rot;
    private final Matrix4f mat;

    private FacingToRotation(Vector3f rot) {
        this.rot = rot;
        this.mat = new Matrix4f();
        this.mat.set(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.toRadians(rot.x)));
        Matrix4f tmp = new Matrix4f();
        tmp.set(new AxisAngle4f(0.0f, 1.0f, 0.0f, (float)Math.toRadians(rot.y)));
        this.mat.mul(tmp);
        tmp.set(new AxisAngle4f(0.0f, 0.0f, 1.0f, (float)Math.toRadians(rot.z)));
        this.mat.mul(tmp);
    }

    public Vector3f getRot() {
        return this.rot;
    }

    public Matrix4f getMat() {
        return new Matrix4f(this.mat);
    }

    @SideOnly(value=Side.CLIENT)
    public void glRotateCurrentMat() {
        GlStateManager.func_179114_b((float)this.rot.x, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rot.y, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)this.rot.z, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public EnumFacing rotate(EnumFacing facing) {
        return TRSRTransformation.rotate((Matrix4f)this.mat, (EnumFacing)facing);
    }

    public EnumFacing resultingRotate(EnumFacing facing) {
        for (EnumFacing face : EnumFacing.values()) {
            if (this.rotate(face) != facing) continue;
            return face;
        }
        return null;
    }

    public static FacingToRotation get(EnumFacing forward, EnumFacing up) {
        return FacingToRotation.values()[forward.ordinal() * 6 + up.ordinal()];
    }
}

