/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import appeng.client.render.VertexFormats;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.vecmath.Vector4f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public class CubeBuilder {
    private VertexFormat format;
    private final List<BakedQuad> output;
    private final EnumMap<EnumFacing, TextureAtlasSprite> textures = new EnumMap(EnumFacing.class);
    private EnumSet<EnumFacing> drawFaces = EnumSet.allOf(EnumFacing.class);
    private final EnumMap<EnumFacing, Vector4f> customUv = new EnumMap(EnumFacing.class);
    private final EnumMap<EnumFacing, Boolean> flipUvs = new EnumMap(EnumFacing.class);
    private byte[] uvRotations = new byte[EnumFacing.values().length];
    private int color = -1;
    private boolean renderFullBright;

    public CubeBuilder(VertexFormat format, List<BakedQuad> output) {
        this.output = output;
        this.format = format;
    }

    public CubeBuilder(VertexFormat format) {
        this(format, new ArrayList<BakedQuad>(6));
    }

    public void addCube(float x1, float y1, float z1, float x2, float y2, float z2) {
        x1 /= 16.0f;
        y1 /= 16.0f;
        z1 /= 16.0f;
        x2 /= 16.0f;
        y2 /= 16.0f;
        z2 /= 16.0f;
        VertexFormat savedFormat = null;
        if (this.renderFullBright) {
            savedFormat = this.format;
            this.format = VertexFormats.getFormatWithLightMap(this.format);
        }
        for (EnumFacing face : this.drawFaces) {
            this.putFace(face, x1, y1, z1, x2, y2, z2);
        }
        if (savedFormat != null) {
            this.format = savedFormat;
        }
    }

    public void addQuad(EnumFacing face, float x1, float y1, float z1, float x2, float y2, float z2) {
        VertexFormat savedFormat = null;
        if (this.renderFullBright) {
            savedFormat = this.format;
            this.format = new VertexFormat(savedFormat);
            if (!this.format.func_177343_g().contains(DefaultVertexFormats.field_181716_p)) {
                this.format.func_181721_a(DefaultVertexFormats.field_181716_p);
            }
        }
        this.putFace(face, x1, y1, z1, x2, y2, z2);
        if (savedFormat != null) {
            this.format = savedFormat;
        }
    }

    private void putFace(EnumFacing face, float x1, float y1, float z1, float x2, float y2, float z2) {
        TextureAtlasSprite texture = this.textures.get(face);
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.format);
        builder.setTexture(texture);
        builder.setQuadOrientation(face);
        UvVector uv = new UvVector();
        Vector4f customUv = this.customUv.get(face);
        if (customUv != null) {
            uv.u1 = texture.func_94214_a((double)customUv.x);
            uv.v1 = texture.func_94207_b((double)customUv.y);
            uv.u2 = texture.func_94214_a((double)customUv.z);
            uv.v2 = texture.func_94207_b((double)customUv.w);
        } else {
            uv = this.getFlipUv(face) ? this.getFlippedUv(face, texture, x1, y1, z1, x2, y2, z2) : this.getDefaultUv(face, texture, x1, y1, z1, x2, y2, z2);
        }
        switch (face) {
            case DOWN: {
                this.putVertexTR(builder, face, x2, y1, z1, uv);
                this.putVertexBR(builder, face, x2, y1, z2, uv);
                this.putVertexBL(builder, face, x1, y1, z2, uv);
                this.putVertexTL(builder, face, x1, y1, z1, uv);
                break;
            }
            case UP: {
                this.putVertexTL(builder, face, x1, y2, z1, uv);
                this.putVertexBL(builder, face, x1, y2, z2, uv);
                this.putVertexBR(builder, face, x2, y2, z2, uv);
                this.putVertexTR(builder, face, x2, y2, z1, uv);
                break;
            }
            case NORTH: {
                this.putVertexBR(builder, face, x2, y2, z1, uv);
                this.putVertexTR(builder, face, x2, y1, z1, uv);
                this.putVertexTL(builder, face, x1, y1, z1, uv);
                this.putVertexBL(builder, face, x1, y2, z1, uv);
                break;
            }
            case SOUTH: {
                this.putVertexBL(builder, face, x1, y2, z2, uv);
                this.putVertexTL(builder, face, x1, y1, z2, uv);
                this.putVertexTR(builder, face, x2, y1, z2, uv);
                this.putVertexBR(builder, face, x2, y2, z2, uv);
                break;
            }
            case WEST: {
                this.putVertexTL(builder, face, x1, y1, z1, uv);
                this.putVertexTR(builder, face, x1, y1, z2, uv);
                this.putVertexBR(builder, face, x1, y2, z2, uv);
                this.putVertexBL(builder, face, x1, y2, z1, uv);
                break;
            }
            case EAST: {
                this.putVertexBR(builder, face, x2, y2, z1, uv);
                this.putVertexBL(builder, face, x2, y2, z2, uv);
                this.putVertexTL(builder, face, x2, y1, z2, uv);
                this.putVertexTR(builder, face, x2, y1, z1, uv);
            }
        }
        int[] vertexData = builder.build().func_178209_a();
        this.output.add(new BakedQuad(vertexData, -1, face, texture, true, this.format));
    }

    private UvVector getDefaultUv(EnumFacing face, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case DOWN: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(z1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(z2 * 16.0f));
                break;
            }
            case UP: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(z1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(z2 * 16.0f));
                break;
            }
            case NORTH: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case SOUTH: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case WEST: {
                uv.u1 = texture.func_94214_a((double)(z1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(z2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case EAST: {
                uv.u1 = texture.func_94214_a((double)(z2 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(z1 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private UvVector getFlippedUv(EnumFacing face, TextureAtlasSprite texture, float x1, float y1, float z1, float x2, float y2, float z2) {
        UvVector uv = new UvVector();
        switch (face) {
            case DOWN: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(z2 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(z1 * 16.0f));
                break;
            }
            case UP: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(z1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(z2 * 16.0f));
                break;
            }
            case NORTH: {
                uv.u1 = texture.func_94214_a((double)(16.0f - x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(16.0f - x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case SOUTH: {
                uv.u1 = texture.func_94214_a((double)(x1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(x2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case WEST: {
                uv.u1 = texture.func_94214_a((double)(z1 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(z2 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
                break;
            }
            case EAST: {
                uv.u1 = texture.func_94214_a((double)(16.0f - z2 * 16.0f));
                uv.v1 = texture.func_94207_b((double)(16.0f - y1 * 16.0f));
                uv.u2 = texture.func_94214_a((double)(16.0f - z1 * 16.0f));
                uv.v2 = texture.func_94207_b((double)(16.0f - y2 * 16.0f));
            }
        }
        return uv;
    }

    private void putVertexTL(UnpackedBakedQuad.Builder builder, EnumFacing face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 1: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 2: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 3: {
                u = uv.u2;
                v = uv.v1;
            }
        }
        this.putVertex(builder, face, x, y, z, u, v);
    }

    private void putVertexTR(UnpackedBakedQuad.Builder builder, EnumFacing face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 1: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 2: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 3: {
                u = uv.u2;
                v = uv.v2;
            }
        }
        this.putVertex(builder, face, x, y, z, u, v);
    }

    private void putVertexBR(UnpackedBakedQuad.Builder builder, EnumFacing face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 1: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 2: {
                u = uv.u1;
                v = uv.v1;
                break;
            }
            case 3: {
                u = uv.u1;
                v = uv.v2;
            }
        }
        this.putVertex(builder, face, x, y, z, u, v);
    }

    private void putVertexBL(UnpackedBakedQuad.Builder builder, EnumFacing face, float x, float y, float z, UvVector uv) {
        float v;
        float u;
        switch (this.uvRotations[face.ordinal()]) {
            default: {
                u = uv.u1;
                v = uv.v2;
                break;
            }
            case 1: {
                u = uv.u2;
                v = uv.v2;
                break;
            }
            case 2: {
                u = uv.u2;
                v = uv.v1;
                break;
            }
            case 3: {
                u = uv.u1;
                v = uv.v1;
            }
        }
        this.putVertex(builder, face, x, y, z, u, v);
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, EnumFacing face, float x, float y, float z, float u, float v) {
        VertexFormat format = builder.getVertexFormat();
        block6: for (int i = 0; i < format.func_177345_h(); ++i) {
            VertexFormatElement e = format.func_177348_c(i);
            switch (e.func_177375_c()) {
                case POSITION: {
                    builder.put(i, new float[]{x, y, z});
                    continue block6;
                }
                case NORMAL: {
                    builder.put(i, new float[]{face.func_82601_c(), face.func_96559_d(), face.func_82599_e()});
                    continue block6;
                }
                case COLOR: {
                    float r = (float)(this.color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(this.color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(this.color & 0xFF) / 255.0f;
                    float a = (float)(this.color >> 24 & 0xFF) / 255.0f;
                    builder.put(i, new float[]{r, g, b, a});
                    continue block6;
                }
                case UV: {
                    if (e.func_177369_e() == 0) {
                        builder.put(i, new float[]{u, v});
                        continue block6;
                    }
                    float lightMapU = 0.0073243305f;
                    float lightMapV = 0.0073243305f;
                    builder.put(i, new float[]{0.0073243305f, 0.0073243305f});
                    continue block6;
                }
                default: {
                    builder.put(i, new float[0]);
                }
            }
        }
    }

    public void setTexture(TextureAtlasSprite texture) {
        for (EnumFacing face : EnumFacing.values()) {
            this.textures.put(face, texture);
        }
    }

    public void setTextures(TextureAtlasSprite up, TextureAtlasSprite down, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite east, TextureAtlasSprite west) {
        this.textures.put(EnumFacing.UP, up);
        this.textures.put(EnumFacing.DOWN, down);
        this.textures.put(EnumFacing.NORTH, north);
        this.textures.put(EnumFacing.SOUTH, south);
        this.textures.put(EnumFacing.EAST, east);
        this.textures.put(EnumFacing.WEST, west);
    }

    public void setTexture(EnumFacing facing, TextureAtlasSprite sprite) {
        this.textures.put(facing, sprite);
    }

    public void setDrawFaces(EnumSet<EnumFacing> drawFaces) {
        this.drawFaces = drawFaces;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setColorRGB(int color) {
        this.setColor(color | 0xFF000000);
    }

    public void setColorRGB(float r, float g, float b) {
        this.setColorRGB((int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f));
    }

    public void setRenderFullBright(boolean renderFullBright) {
        this.renderFullBright = renderFullBright;
    }

    public void setCustomUv(EnumFacing facing, float u1, float v1, float u2, float v2) {
        this.customUv.put(facing, new Vector4f(u1, v1, u2, v2));
    }

    public void setFlipUv(EnumFacing facing, boolean val) {
        this.flipUvs.put(facing, val);
    }

    public boolean getFlipUv(EnumFacing facing) {
        return this.flipUvs.containsKey(facing) && this.flipUvs.get(facing) != false;
    }

    public void resetFlipUvs() {
        this.flipUvs.clear();
    }

    public void setUvRotation(EnumFacing facing, int rotation) {
        if (rotation == 2) {
            rotation = 3;
        } else if (rotation == 3) {
            rotation = 2;
        }
        Preconditions.checkArgument((rotation >= 0 && rotation <= 3 ? 1 : 0) != 0, (Object)"rotation");
        this.uvRotations[facing.ordinal()] = (byte)rotation;
    }

    public List<BakedQuad> getOutput() {
        return this.output;
    }

    private static final class UvVector {
        float u1;
        float u2;
        float v1;
        float v2;

        private UvVector() {
        }
    }
}

