/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.crafting;

import appeng.client.render.model.BaseBakedModel;
import appeng.items.misc.ItemEncodedPattern;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.input.Keyboard;

class ItemEncodedPatternBakedModel
extends BaseBakedModel {
    private final IBakedModel baseModel;
    private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
    private final CustomOverrideList overrides;

    ItemEncodedPatternBakedModel(IBakedModel baseModel, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms) {
        super(baseModel);
        this.baseModel = baseModel;
        this.transforms = transforms;
        this.overrides = new CustomOverrideList();
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        return this.baseModel.func_188616_a(state, side, rand);
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.overrides;
    }

    private class CustomOverrideList
    extends ItemOverrideList {
        CustomOverrideList() {
            super((List)ItemEncodedPatternBakedModel.this.baseModel.func_188617_f().getOverrides());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            ItemEncodedPattern iep;
            ItemStack output;
            boolean shiftHeld;
            boolean bl = shiftHeld = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
            if (shiftHeld && !(output = (iep = (ItemEncodedPattern)stack.func_77973_b()).getOutput(stack)).func_190926_b()) {
                IBakedModel realModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(output);
                realModel = realModel.func_188617_f().handleItemState(realModel, output, world, entity);
                return new ShiftHoldingModelWrapper(realModel);
            }
            return ItemEncodedPatternBakedModel.this.baseModel.func_188617_f().handleItemState(originalModel, stack, world, entity);
        }
    }

    private class ShiftHoldingModelWrapper
    extends BaseBakedModel {
        private final IBakedModel outputModel;

        private ShiftHoldingModelWrapper(IBakedModel outputModel) {
            super(ItemEncodedPatternBakedModel.this.baseModel);
            this.outputModel = outputModel;
        }

        @Override
        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            IBakedModel selectedModel = cameraTransformType == ItemCameraTransforms.TransformType.GUI ? this.outputModel : ItemEncodedPatternBakedModel.this.baseModel;
            if (selectedModel.func_177556_c() != ItemEncodedPatternBakedModel.this.baseModel.func_177556_c()) {
                GlStateManager.func_179145_e();
            }
            if (selectedModel instanceof IBakedModel) {
                return selectedModel.handlePerspective(cameraTransformType);
            }
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)ItemEncodedPatternBakedModel.this.transforms, (ItemCameraTransforms.TransformType)cameraTransformType);
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return ItemEncodedPatternBakedModel.this.baseModel.func_188616_a(state, side, rand);
        }
    }
}

