/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.block.AEBaseTileBlock;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.AutoRotatingCacheKey;
import appeng.client.render.model.BaseBakedModel;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;

public class AutoRotatingModel
extends BaseBakedModel {
    private final IBakedModel parent;
    private final LoadingCache<AutoRotatingCacheKey, List<BakedQuad>> quadCache;

    public AutoRotatingModel(IBakedModel parent) {
        super(parent);
        this.parent = parent;
        this.quadCache = CacheBuilder.newBuilder().maximumSize(252L).build((CacheLoader)new CacheLoader<AutoRotatingCacheKey, List<BakedQuad>>(){

            public List<BakedQuad> load(AutoRotatingCacheKey key) throws Exception {
                return AutoRotatingModel.this.getRotatedModel(key.getBlockState(), key.getSide(), key.getForward(), key.getUp());
            }
        });
    }

    private List<BakedQuad> getRotatedModel(IBlockState state, EnumFacing side, EnumFacing forward, EnumFacing up) {
        FacingToRotation f2r = FacingToRotation.get(forward, up);
        List original = this.parent.func_188616_a(state, f2r.resultingRotate(side), 0L);
        ArrayList<BakedQuad> rotated = new ArrayList<BakedQuad>(original.size());
        for (BakedQuad quad : original) {
            VertexFormat format = quad.getFormat();
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
            VertexRotator rot = new VertexRotator(f2r, quad.func_178210_d());
            rot.setParent((IVertexConsumer)builder);
            quad.pipe((IVertexConsumer)rot);
            if (quad.func_178210_d() != null) {
                builder.setQuadOrientation(f2r.rotate(quad.func_178210_d()));
            } else {
                builder.setQuadOrientation(null);
            }
            UnpackedBakedQuad unpackedQuad = builder.build();
            BakedQuad packedQuad = new BakedQuad(unpackedQuad.func_178209_a(), quad.func_178211_c(), unpackedQuad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
            rotated.add(packedQuad);
        }
        return rotated;
    }

    @Override
    public boolean func_177555_b() {
        return this.parent.func_177555_b();
    }

    @Override
    public boolean func_177556_c() {
        return this.parent.func_177556_c();
    }

    @Override
    public boolean func_188618_c() {
        return this.parent.func_188618_c();
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.parent.func_177554_e();
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return this.parent.func_177552_f();
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.parent.func_188617_f();
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (!(state instanceof IExtendedBlockState)) {
            return this.parent.func_188616_a(state, side, rand);
        }
        IExtendedBlockState extState = (IExtendedBlockState)state;
        EnumFacing forward = (EnumFacing)extState.getValue((IUnlistedProperty)AEBaseTileBlock.FORWARD);
        EnumFacing up = (EnumFacing)extState.getValue((IUnlistedProperty)AEBaseTileBlock.UP);
        if (forward == null || up == null) {
            return this.parent.func_188616_a(state, side, rand);
        }
        if (extState.getUnlistedProperties().size() != 2) {
            return this.getRotatedModel((IBlockState)extState, side, forward, up);
        }
        AutoRotatingCacheKey key = new AutoRotatingCacheKey(extState.getClean(), forward, up, side);
        return (List)this.quadCache.getUnchecked((Object)key);
    }

    public static class VertexRotator
    extends QuadGatheringTransformer {
        private final FacingToRotation f2r;
        private final EnumFacing face;

        public VertexRotator(FacingToRotation f2r, EnumFacing face) {
            this.f2r = f2r;
            this.face = face;
        }

        public void setParent(IVertexConsumer parent) {
            super.setParent(parent);
            if (Objects.equal((Object)this.getVertexFormat(), (Object)parent.getVertexFormat())) {
                return;
            }
            this.setVertexFormat(parent.getVertexFormat());
        }

        protected void processQuad() {
            VertexFormat format = this.parent.getVertexFormat();
            int count = format.func_177345_h();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < count; ++e) {
                    VertexFormatElement element = format.func_177348_c(e);
                    if (element.func_177375_c() == VertexFormatElement.EnumUsage.POSITION) {
                        this.parent.put(e, this.transform(this.quadData[e][v]));
                        continue;
                    }
                    if (element.func_177375_c() == VertexFormatElement.EnumUsage.NORMAL) {
                        this.parent.put(e, this.transformNormal(this.quadData[e][v]));
                        continue;
                    }
                    this.parent.put(e, this.quadData[e][v]);
                }
            }
        }

        private float[] transform(float[] fs) {
            switch (fs.length) {
                case 3: {
                    Vector3f vec = new Vector3f(fs[0], fs[1], fs[2]);
                    vec.x -= 0.5f;
                    vec.y -= 0.5f;
                    vec.z -= 0.5f;
                    this.f2r.getMat().transform(vec);
                    vec.x += 0.5f;
                    vec.y += 0.5f;
                    vec.z += 0.5f;
                    return new float[]{vec.x, vec.y, vec.z};
                }
                case 4: {
                    Vector4f vecc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                    vecc.x -= 0.5f;
                    vecc.y -= 0.5f;
                    vecc.z -= 0.5f;
                    this.f2r.getMat().transform((Tuple4f)vecc);
                    vecc.x += 0.5f;
                    vecc.y += 0.5f;
                    vecc.z += 0.5f;
                    return new float[]{vecc.x, vecc.y, vecc.z, vecc.w};
                }
            }
            return fs;
        }

        private float[] transformNormal(float[] fs) {
            if (this.face == null) {
                switch (fs.length) {
                    case 3: {
                        Vector3f vec = new Vector3f(fs);
                        this.f2r.getMat().transform(vec);
                        return new float[]{vec.getX(), vec.getY(), vec.getZ()};
                    }
                    case 4: {
                        Vector4f vec4 = new Vector4f(fs);
                        this.f2r.getMat().transform((Tuple4f)vec4);
                        return new float[]{vec4.getX(), vec4.getY(), vec4.getZ(), 0.0f};
                    }
                }
                return fs;
            }
            switch (fs.length) {
                case 3: {
                    Vec3i vec = this.f2r.rotate(this.face).func_176730_m();
                    return new float[]{vec.func_177958_n(), vec.func_177956_o(), vec.func_177952_p()};
                }
                case 4: {
                    Vector4f veccc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                    Vec3i vecc = this.f2r.rotate(this.face).func_176730_m();
                    return new float[]{vecc.func_177958_n(), vecc.func_177956_o(), vecc.func_177952_p(), veccc.w};
                }
            }
            return fs;
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(EnumFacing orientation) {
            this.parent.setQuadOrientation(orientation);
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }
    }
}

