/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public abstract class BaseModel
implements IModel {
    private IModel baseModel;
    protected final ResourceLocation baseLocation;

    public BaseModel(@Nonnull ResourceLocation base) {
        this.baseLocation = base;
    }

    public IModelState getDefaultState() {
        return this.getBaseModel().getDefaultState();
    }

    protected IBakedModel getBakedBaseModel(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        try {
            return this.getBaseModel().bake(state, format, bakedTextureGetter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(this.baseLocation);
    }

    protected IModel getBaseModel() {
        if (this.baseModel == null) {
            try {
                this.baseModel = ModelLoaderRegistry.getModel((ResourceLocation)this.baseLocation);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.baseModel;
    }
}

