/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.BaseBakedModel;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

class ColorApplicatorBakedModel
extends BaseBakedModel {
    private final IBakedModel baseModel;
    private final EnumMap<EnumFacing, List<BakedQuad>> quadsBySide;
    private final List<BakedQuad> generalQuads;

    ColorApplicatorBakedModel(IBakedModel baseModel, TextureAtlasSprite texDark, TextureAtlasSprite texMedium, TextureAtlasSprite texBright) {
        super(baseModel);
        this.baseModel = baseModel;
        this.generalQuads = this.fixQuadTint(null, texDark, texMedium, texBright);
        this.quadsBySide = new EnumMap(EnumFacing.class);
        for (EnumFacing facing : EnumFacing.values()) {
            this.quadsBySide.put(facing, this.fixQuadTint(facing, texDark, texMedium, texBright));
        }
    }

    private List<BakedQuad> fixQuadTint(EnumFacing facing, TextureAtlasSprite texDark, TextureAtlasSprite texMedium, TextureAtlasSprite texBright) {
        List quads = this.baseModel.func_188616_a(null, facing, 0L);
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>(quads.size());
        for (BakedQuad quad : quads) {
            int tint;
            if (quad.func_187508_a() == texDark) {
                tint = 1;
            } else if (quad.func_187508_a() == texMedium) {
                tint = 2;
            } else if (quad.func_187508_a() == texBright) {
                tint = 3;
            } else {
                result.add(quad);
                continue;
            }
            BakedQuad newQuad = new BakedQuad(quad.func_178209_a(), tint, quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
            result.add(newQuad);
        }
        return result;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.generalQuads;
        }
        return this.quadsBySide.get(side);
    }
}

