/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.BaseModel;
import appeng.client.render.model.ColorApplicatorBakedModel;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.model.IModelState;

public class ColorApplicatorModel
extends BaseModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2", "item/color_applicator_colored");
    private static final ResourceLocation TEXTURE_DARK = new ResourceLocation("appliedenergistics2", "items/color_applicator_tip_dark");
    private static final ResourceLocation TEXTURE_MEDIUM = new ResourceLocation("appliedenergistics2", "items/color_applicator_tip_medium");
    private static final ResourceLocation TEXTURE_BRIGHT = new ResourceLocation("appliedenergistics2", "items/color_applicator_tip_bright");

    public ColorApplicatorModel() {
        super(MODEL_BASE);
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)TEXTURE_DARK, (Object)TEXTURE_MEDIUM, (Object)TEXTURE_BRIGHT);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel baseModel = this.getBakedBaseModel(state, format, bakedTextureGetter);
        TextureAtlasSprite texDark = bakedTextureGetter.apply(TEXTURE_DARK);
        TextureAtlasSprite texMedium = bakedTextureGetter.apply(TEXTURE_MEDIUM);
        TextureAtlasSprite texBright = bakedTextureGetter.apply(TEXTURE_BRIGHT);
        return new ColorApplicatorBakedModel(baseModel, texDark, texMedium, texBright);
    }
}

