/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.block.storage.BlockDrive;
import appeng.block.storage.DriveSlotState;
import appeng.block.storage.DriveSlotsState;
import appeng.client.render.model.BaseBakedModel;
import appeng.client.render.model.MatrixVertexTransformer;
import appeng.core.AELog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.property.IExtendedBlockState;

public class DriveBakedModel
extends BaseBakedModel {
    private final IBakedModel bakedBase;
    private final Map<DriveSlotState, IBakedModel> bakedCells;

    public DriveBakedModel(IBakedModel bakedBase, Map<DriveSlotState, IBakedModel> bakedCells) {
        super(bakedBase);
        this.bakedBase = bakedBase;
        this.bakedCells = bakedCells;
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        ArrayList<BakedQuad> result = new ArrayList<BakedQuad>();
        result.addAll(this.bakedBase.func_188616_a(state, side, rand));
        if (side == null && state instanceof IExtendedBlockState) {
            IExtendedBlockState extState = (IExtendedBlockState)state;
            DriveSlotsState slotsState = (DriveSlotsState)extState.getValue(BlockDrive.SLOTS_STATE);
            if (slotsState != null) {
                for (int row = 0; row < 5; ++row) {
                    for (int col = 0; col < 2; ++col) {
                        DriveSlotState slotState = slotsState.getState(row * 2 + col);
                        IBakedModel bakedCell = this.bakedCells.get((Object)slotState);
                        Matrix4f transform = new Matrix4f();
                        transform.setIdentity();
                        float xOffset = (float)(-col * 7) / 16.0f;
                        float yOffset = (float)(-row * 3) / 16.0f;
                        transform.setTranslation(new Vector3f(xOffset, yOffset, 0.0f));
                        MatrixVertexTransformer transformer = new MatrixVertexTransformer(transform);
                        for (BakedQuad bakedQuad : bakedCell.func_188616_a(state, null, rand)) {
                            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(bakedQuad.getFormat());
                            transformer.setParent((IVertexConsumer)builder);
                            transformer.setVertexFormat(builder.getVertexFormat());
                            bakedQuad.pipe((IVertexConsumer)transformer);
                            result.add((BakedQuad)builder.build());
                        }
                    }
                }
            } else {
                AELog.error("BlockState does not contain DriveSlotsState. THIS IS NOT NORMAL. BlockState supplied is of type %s.", state.getClass().getName());
                AELog.error(state.toString(), new Object[0]);
            }
        }
        return result;
    }
}

