/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.block.storage.DriveSlotState;
import appeng.client.render.model.BaseModel;
import appeng.client.render.model.DriveBakedModel;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class DriveModel
extends BaseModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2:block/drive_base");
    private static final Map<DriveSlotState, ResourceLocation> MODELS_CELLS = ImmutableMap.of((Object)((Object)DriveSlotState.EMPTY), (Object)new ResourceLocation("appliedenergistics2:block/drive_cell_empty"), (Object)((Object)DriveSlotState.OFFLINE), (Object)new ResourceLocation("appliedenergistics2:block/drive_cell_off"), (Object)((Object)DriveSlotState.ONLINE), (Object)new ResourceLocation("appliedenergistics2:block/drive_cell_on"), (Object)((Object)DriveSlotState.TYPES_FULL), (Object)new ResourceLocation("appliedenergistics2:block/drive_cell_types_full"), (Object)((Object)DriveSlotState.FULL), (Object)new ResourceLocation("appliedenergistics2:block/drive_cell_full"));

    public DriveModel() {
        super(MODEL_BASE);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().add((Object)MODEL_BASE).addAll(MODELS_CELLS.values()).build();
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        EnumMap<DriveSlotState, IBakedModel> cellModels = new EnumMap<DriveSlotState, IBakedModel>(DriveSlotState.class);
        try {
            for (DriveSlotState slotState : MODELS_CELLS.keySet()) {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)MODELS_CELLS.get((Object)slotState));
                cellModels.put(slotState, model.bake(state, format, bakedTextureGetter));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        IBakedModel bakedBase = this.getBakedBaseModel(state, format, bakedTextureGetter);
        return new DriveBakedModel(bakedBase, cellModels);
    }
}

