/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.RenderHelper;
import appeng.decorative.solid.BlockQuartzGlass;
import appeng.decorative.solid.GlassState;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

class GlassBakedModel
implements IBakedModel {
    private static final byte[][][] OFFSETS = GlassBakedModel.generateOffsets();
    static final ResourceLocation TEXTURE_A = new ResourceLocation("appliedenergistics2:blocks/glass/quartz_glass_a");
    static final ResourceLocation TEXTURE_B = new ResourceLocation("appliedenergistics2:blocks/glass/quartz_glass_b");
    static final ResourceLocation TEXTURE_C = new ResourceLocation("appliedenergistics2:blocks/glass/quartz_glass_c");
    static final ResourceLocation TEXTURE_D = new ResourceLocation("appliedenergistics2:blocks/glass/quartz_glass_d");
    static final ResourceLocation[] TEXTURES_FRAME = GlassBakedModel.generateTexturesFrame();
    private final TextureAtlasSprite[] glassTextures;
    private final TextureAtlasSprite[] frameTextures;
    private final VertexFormat vertexFormat;
    private final PerspectiveMapWrapper perspective;

    private static ResourceLocation[] generateTexturesFrame() {
        return (ResourceLocation[])IntStream.range(1, 16).mapToObj(Integer::toBinaryString).map(s -> Strings.padStart((String)s, (int)4, (char)'0')).map(s -> new ResourceLocation("appliedenergistics2:blocks/glass/quartz_glass_frame" + s)).toArray(ResourceLocation[]::new);
    }

    public GlassBakedModel(ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        this.glassTextures = new TextureAtlasSprite[]{bakedTextureGetter.apply(TEXTURE_A), bakedTextureGetter.apply(TEXTURE_B), bakedTextureGetter.apply(TEXTURE_C), bakedTextureGetter.apply(TEXTURE_D)};
        this.vertexFormat = format;
        this.frameTextures = new TextureAtlasSprite[16];
        for (int i = 0; i < TEXTURES_FRAME.length; ++i) {
            this.frameTextures[1 + i] = bakedTextureGetter.apply(TEXTURES_FRAME[i]);
        }
        this.perspective = new PerspectiveMapWrapper((IBakedModel)this, transforms);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (!(state instanceof IExtendedBlockState) || side == null) {
            return Collections.emptyList();
        }
        IExtendedBlockState extState = (IExtendedBlockState)state;
        GlassState glassState = (GlassState)extState.getValue((IUnlistedProperty)BlockQuartzGlass.GLASS_STATE);
        int cx = Math.abs(glassState.getX() % 10);
        int cy = Math.abs(glassState.getY() % 10);
        int cz = Math.abs(glassState.getZ() % 10);
        int u = OFFSETS[cx][cy][cz] % 4;
        int v = OFFSETS[9 - cx][9 - cy][9 - cz] % 4;
        int texIdx = Math.abs((OFFSETS[cx][cy][cz] + (glassState.getX() + glassState.getY() + glassState.getZ())) % 4);
        if (texIdx < 2) {
            u /= 2;
            v /= 2;
        }
        TextureAtlasSprite glassTexture = this.glassTextures[texIdx];
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(5);
        List<Vec3d> corners = RenderHelper.getFaceCorners(side);
        quads.add(this.createQuad(side, corners, glassTexture, u, v));
        int edgeBitmask = GlassBakedModel.makeBitmask(glassState, side);
        TextureAtlasSprite sideSprite = this.frameTextures[edgeBitmask];
        if (sideSprite != null) {
            quads.add(this.createQuad(side, corners, sideSprite, 0.0f, 0.0f));
        }
        return quads;
    }

    private static int makeBitmask(GlassState state, EnumFacing side) {
        switch (side) {
            case DOWN: {
                return GlassBakedModel.makeBitmask(state, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST);
            }
            case UP: {
                return GlassBakedModel.makeBitmask(state, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST);
            }
            case NORTH: {
                return GlassBakedModel.makeBitmask(state, EnumFacing.UP, EnumFacing.WEST, EnumFacing.DOWN, EnumFacing.EAST);
            }
            case SOUTH: {
                return GlassBakedModel.makeBitmask(state, EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN, EnumFacing.WEST);
            }
            case WEST: {
                return GlassBakedModel.makeBitmask(state, EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.DOWN, EnumFacing.NORTH);
            }
            case EAST: {
                return GlassBakedModel.makeBitmask(state, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN, EnumFacing.SOUTH);
            }
        }
        throw new IllegalArgumentException("Unsupported side!");
    }

    private static int makeBitmask(GlassState state, EnumFacing up, EnumFacing right, EnumFacing down, EnumFacing left) {
        int bitmask = 0;
        if (!state.isFlushWith(up)) {
            bitmask |= 1;
        }
        if (!state.isFlushWith(right)) {
            bitmask |= 2;
        }
        if (!state.isFlushWith(down)) {
            bitmask |= 4;
        }
        if (!state.isFlushWith(left)) {
            bitmask |= 8;
        }
        return bitmask;
    }

    private BakedQuad createQuad(EnumFacing side, List<Vec3d> corners, TextureAtlasSprite sprite, float uOffset, float vOffset) {
        return this.createQuad(side, corners.get(0), corners.get(1), corners.get(2), corners.get(3), sprite, uOffset, vOffset);
    }

    private BakedQuad createQuad(EnumFacing side, Vec3d c1, Vec3d c2, Vec3d c3, Vec3d c4, TextureAtlasSprite sprite, float uOffset, float vOffset) {
        Vec3d normal = new Vec3d(side.func_176730_m());
        float u1 = MathHelper.func_76131_a((float)(0.0f - uOffset), (float)0.0f, (float)16.0f);
        float u2 = MathHelper.func_76131_a((float)(16.0f - uOffset), (float)0.0f, (float)16.0f);
        float v1 = MathHelper.func_76131_a((float)(0.0f - vOffset), (float)0.0f, (float)16.0f);
        float v2 = MathHelper.func_76131_a((float)(16.0f - vOffset), (float)0.0f, (float)16.0f);
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.vertexFormat);
        builder.setTexture(sprite);
        this.putVertex(builder, normal, c1.field_72450_a, c1.field_72448_b, c1.field_72449_c, sprite, u1, v1);
        this.putVertex(builder, normal, c2.field_72450_a, c2.field_72448_b, c2.field_72449_c, sprite, u1, v2);
        this.putVertex(builder, normal, c3.field_72450_a, c3.field_72448_b, c3.field_72449_c, sprite, u2, v2);
        this.putVertex(builder, normal, c4.field_72450_a, c4.field_72448_b, c4.field_72449_c, sprite, u2, v1);
        return builder.build();
    }

    private void putVertex(UnpackedBakedQuad.Builder builder, Vec3d normal, double x, double y, double z, TextureAtlasSprite sprite, float u, float v) {
        block6: for (int e = 0; e < this.vertexFormat.func_177345_h(); ++e) {
            switch (this.vertexFormat.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{(float)x, (float)y, (float)z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (this.vertexFormat.func_177348_c(e).func_177369_e() == 0) {
                        u = sprite.func_94214_a((double)u);
                        v = sprite.func_94207_b((double)v);
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{(float)normal.field_72450_a, (float)normal.field_72448_b, (float)normal.field_72449_c, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.frameTextures[this.frameTextures.length - 1];
    }

    @Deprecated
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private static byte[][][] generateOffsets() {
        Random r = new Random(924L);
        byte[][][] offset = new byte[10][10][10];
        for (int x = 0; x < 10; ++x) {
            for (int y = 0; y < 10; ++y) {
                r.nextBytes(offset[x][y]);
            }
        }
        return offset;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return this.perspective.handlePerspective(cameraTransformType);
    }
}

