/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.model.BaseModel;
import appeng.client.render.model.SkyCompassBakedModel;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;

public class SkyCompassModel
extends BaseModel {
    private static final ResourceLocation MODEL_BASE = new ResourceLocation("appliedenergistics2:block/sky_compass_base");
    private static final ResourceLocation MODEL_POINTER = new ResourceLocation("appliedenergistics2:block/sky_compass_pointer");
    private static final List<ResourceLocation> DEPENDENCIES = ImmutableList.of((Object)MODEL_BASE, (Object)MODEL_POINTER);
    private IModel pointerModel;

    public SkyCompassModel() {
        super(MODEL_BASE);
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return DEPENDENCIES;
    }

    public Collection<ResourceLocation> getTextures() {
        return Collections.emptyList();
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        IBakedModel bakedBase = this.getBakedBaseModel(state, format, bakedTextureGetter);
        IBakedModel bakedPointer = this.getPointerModel().bake(state, format, bakedTextureGetter);
        return new SkyCompassBakedModel(bakedBase, bakedPointer);
    }

    private IModel getPointerModel() {
        if (this.pointerModel == null) {
            try {
                this.pointerModel = ModelLoaderRegistry.getModel((ResourceLocation)MODEL_POINTER);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.pointerModel;
    }
}

