/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.renderable;

import appeng.client.render.renderable.Renderable;
import java.nio.FloatBuffer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;
import org.lwjgl.util.vector.Matrix4f;

public class ItemRenderable<T extends TileEntity>
implements Renderable<T> {
    private final Function<T, Pair<ItemStack, Matrix4f>> f;

    public ItemRenderable(Function<T, Pair<ItemStack, Matrix4f>> f) {
        this.f = f;
    }

    @Override
    public void renderTileEntityAt(T te, double x, double y, double z, float partialTicks, int destroyStage) {
        Pair<ItemStack, Matrix4f> pair = this.f.apply(te);
        if (pair != null && !((ItemStack)pair.getLeft()).func_190926_b()) {
            GlStateManager.func_179094_E();
            if (pair.getRight() != null) {
                FloatBuffer matrix = BufferUtils.createFloatBuffer((int)16);
                ((Matrix4f)pair.getRight()).store(matrix);
                matrix.flip();
                GlStateManager.func_179110_a((FloatBuffer)matrix);
            }
            Minecraft.func_71410_x().func_175599_af().func_181564_a((ItemStack)pair.getLeft(), ItemCameraTransforms.TransformType.GROUND);
            GlStateManager.func_179121_F();
        }
    }

    @Override
    public void renderTileEntityFast(T te, double x, double y, double z, float partialTicks, int destroyStage, BufferBuilder buffer) {
    }
}

