/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.CraftingItemList;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEPartLocation;
import appeng.container.AEBaseContainer;
import appeng.container.guisync.GuiSync;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketValueConfig;
import appeng.helpers.ICustomNameObject;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.CraftingCPUCluster;
import appeng.tile.crafting.TileCraftingTile;
import appeng.util.Platform;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IContainerListener;

public class ContainerCraftingCPU
extends AEBaseContainer
implements IMEMonitorHandlerReceiver<IAEItemStack>,
ICustomNameObject {
    private final IItemList<IAEItemStack> list = AEApi.instance().storage().createItemList();
    private IGrid network;
    private CraftingCPUCluster monitor = null;
    private String cpuName = null;
    @GuiSync(value=0)
    public long eta = -1L;

    public ContainerCraftingCPU(InventoryPlayer ip, Object te) {
        super(ip, te);
        IGridHost host = (IGridHost)(te instanceof IGridHost ? te : null);
        if (host != null) {
            this.findNode(host, AEPartLocation.INTERNAL);
            for (AEPartLocation d : AEPartLocation.SIDE_LOCATIONS) {
                this.findNode(host, d);
            }
        }
        if (te instanceof TileCraftingTile) {
            this.setCPU((ICraftingCPU)((Object)((IAEMultiBlock)te).getCluster()));
        }
        if (this.getNetwork() == null && Platform.isServer()) {
            this.setValidContainer(false);
        }
    }

    private void findNode(IGridHost host, AEPartLocation d) {
        IGridNode node;
        if (this.getNetwork() == null && (node = host.getGridNode(d)) != null) {
            this.setNetwork(node.getGrid());
        }
    }

    protected void setCPU(ICraftingCPU c) {
        if (c == this.getMonitor()) {
            return;
        }
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
        for (Object g : this.field_75149_d) {
            if (!(g instanceof EntityPlayer)) continue;
            try {
                NetworkHandler.instance().sendTo(new PacketValueConfig("CraftingStatus", "Clear"), (EntityPlayerMP)g);
            }
            catch (IOException e) {
                AELog.debug(e);
            }
        }
        if (c instanceof CraftingCPUCluster) {
            this.cpuName = c.getName();
            this.setMonitor((CraftingCPUCluster)c);
            this.list.resetStatus();
            this.getMonitor().getListOfItem(this.list, CraftingItemList.ALL);
            this.getMonitor().addListener(this, (Object)null);
            this.setEstimatedTime(0L);
        } else {
            this.setMonitor(null);
            this.cpuName = "";
            this.setEstimatedTime(-1L);
        }
    }

    public void cancelCrafting() {
        if (this.getMonitor() != null) {
            this.getMonitor().cancel();
        }
        this.setEstimatedTime(-1L);
    }

    public void func_82847_b(IContainerListener c) {
        super.func_82847_b(c);
        if (this.field_75149_d.isEmpty() && this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (this.getMonitor() != null) {
            this.getMonitor().removeListener(this);
        }
    }

    @Override
    public void func_75142_b() {
        if (Platform.isServer() && this.getMonitor() != null && !this.list.isEmpty()) {
            try {
                if (this.getEstimatedTime() >= 0L) {
                    long elapsedTime = this.getMonitor().getElapsedTime();
                    double remainingItems = this.getMonitor().getRemainingItemCount();
                    double startItems = this.getMonitor().getStartItemCount();
                    long eta = (long)((double)elapsedTime / Math.max(1.0, startItems - remainingItems) * remainingItems);
                    this.setEstimatedTime(eta);
                }
                PacketMEInventoryUpdate a = new PacketMEInventoryUpdate(0);
                PacketMEInventoryUpdate b = new PacketMEInventoryUpdate(1);
                PacketMEInventoryUpdate c = new PacketMEInventoryUpdate(2);
                for (IAEItemStack out : this.list) {
                    a.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.STORAGE));
                    b.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.ACTIVE));
                    c.appendItem(this.getMonitor().getItemStack(out, CraftingItemList.PENDING));
                }
                this.list.resetStatus();
                for (IAEItemStack g : this.field_75149_d) {
                    if (!(g instanceof EntityPlayer)) continue;
                    if (!a.isEmpty()) {
                        NetworkHandler.instance().sendTo(a, (EntityPlayerMP)g);
                    }
                    if (!b.isEmpty()) {
                        NetworkHandler.instance().sendTo(b, (EntityPlayerMP)g);
                    }
                    if (c.isEmpty()) continue;
                    NetworkHandler.instance().sendTo(c, (EntityPlayerMP)g);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.func_75142_b();
    }

    @Override
    public boolean isValid(Object verificationToken) {
        return true;
    }

    @Override
    public void postChange(IBaseMonitor<IAEItemStack> monitor, Iterable<IAEItemStack> change, BaseActionSource actionSource) {
        for (IAEItemStack is : change) {
            is = is.copy();
            is.setStackSize(1L);
            this.list.add(is);
        }
    }

    @Override
    public void onListUpdate() {
    }

    @Override
    public String getAEDisplayName() {
        return this.cpuName;
    }

    @Override
    public boolean hasAEDisplayName() {
        return this.cpuName != null && this.cpuName.length() > 0;
    }

    public long getEstimatedTime() {
        return this.eta;
    }

    private void setEstimatedTime(long eta) {
        this.eta = eta;
    }

    CraftingCPUCluster getMonitor() {
        return this.monitor;
    }

    private void setMonitor(CraftingCPUCluster monitor) {
        this.monitor = monitor;
    }

    IGrid getNetwork() {
        return this.network;
    }

    private void setNetwork(IGrid network) {
        this.network = network;
    }
}

