/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.container.interfaces.IProgressProvider;
import appeng.container.slot.SlotOutput;
import appeng.container.slot.SlotRestrictedInput;
import appeng.tile.misc.TileInscriber;
import appeng.util.Platform;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerInscriber
extends ContainerUpgradeable
implements IProgressProvider {
    private final TileInscriber ti;
    private final Slot top;
    private final Slot middle;
    private final Slot bottom;
    @GuiSync(value=2)
    public int maxProcessingTime = -1;
    @GuiSync(value=3)
    public int processingTime = -1;

    public ContainerInscriber(InventoryPlayer ip, TileInscriber te) {
        super(ip, te);
        this.ti = te;
        this.top = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_PLATE, (IInventory)this.ti, 0, 45, 16, this.getInventoryPlayer());
        this.func_75146_a(this.top);
        this.bottom = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_PLATE, (IInventory)this.ti, 1, 45, 62, this.getInventoryPlayer());
        this.func_75146_a(this.bottom);
        this.middle = new SlotRestrictedInput(SlotRestrictedInput.PlacableItemType.INSCRIBER_INPUT, (IInventory)this.ti, 2, 63, 39, this.getInventoryPlayer());
        this.func_75146_a(this.middle);
        this.func_75146_a(new SlotOutput((IInventory)this.ti, 3, 113, 40, -1));
    }

    @Override
    protected int getHeight() {
        return 176;
    }

    @Override
    protected void setupConfig() {
        this.setupUpgrades();
    }

    @Override
    protected boolean supportCapacity() {
        return false;
    }

    @Override
    public int availableUpgrades() {
        return 5;
    }

    @Override
    protected int getToolboxY() {
        return 22 + this.availableUpgrades() * 18;
    }

    @Override
    public void func_75142_b() {
        this.standardDetectAndSendChanges();
        if (Platform.isServer()) {
            this.maxProcessingTime = this.ti.getMaxProcessingTime();
            this.processingTime = this.ti.getProcessingTime();
        }
    }

    @Override
    public boolean isValidForSlot(Slot s, ItemStack is) {
        if (s.field_75224_c == this.ti) {
            return this.ti.func_94041_b(s.getSlotIndex(), is);
        }
        return super.isValidForSlot(s, is);
    }

    @Override
    public int getCurrentProgress() {
        return this.processingTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProcessingTime;
    }
}

