/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.container.AEBaseContainer;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.helpers.DualityInterface;
import appeng.helpers.IInterfaceHost;
import appeng.helpers.InventoryAction;
import appeng.items.misc.ItemEncodedPattern;
import appeng.parts.misc.PartInterface;
import appeng.parts.reporting.PartInterfaceTerminal;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.tile.misc.TileInterface;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorIInventory;
import appeng.util.inv.AdaptorPlayerHand;
import appeng.util.inv.WrapperInvSlot;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public final class ContainerInterfaceTerminal
extends AEBaseContainer {
    private static long autoBase = Long.MIN_VALUE;
    private final Map<IInterfaceHost, InvTracker> diList = new HashMap<IInterfaceHost, InvTracker>();
    private final Map<Long, InvTracker> byId = new HashMap<Long, InvTracker>();
    private IGrid grid;
    private NBTTagCompound data = new NBTTagCompound();

    public ContainerInterfaceTerminal(InventoryPlayer ip, PartInterfaceTerminal anchor) {
        super(ip, anchor);
        if (Platform.isServer()) {
            this.grid = anchor.getActionableNode().getGrid();
        }
        this.bindPlayerInventory(ip, 0, 0);
    }

    @Override
    public void func_75142_b() {
        IGridNode agn;
        if (Platform.isClient()) {
            return;
        }
        super.func_75142_b();
        if (this.grid == null) {
            return;
        }
        int total = 0;
        boolean missing = false;
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            InvTracker t;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                if (!gn.isActive() || (ih = (IInterfaceHost)gn.getMachine()).getInterfaceDuality().getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) == YesNo.NO) continue;
                t = this.diList.get(ih);
                if (t == null) {
                    missing = true;
                } else {
                    dual = ih.getInterfaceDuality();
                    if (!t.unlocalizedName.equals(dual.getTermName())) {
                        missing = true;
                    }
                }
                ++total;
            }
        }
        if (total != this.diList.size() || missing) {
            this.regenList(this.data);
        } else {
            for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
                InvTracker inv = en.getValue();
                for (int x = 0; x < inv.server.func_70302_i_(); ++x) {
                    if (!this.isDifferent(inv.server.func_70301_a(x), inv.client.func_70301_a(x))) continue;
                    this.addItems(this.data, inv, x, 1);
                }
            }
        }
        if (!this.data.func_82582_d()) {
            try {
                NetworkHandler.instance().sendTo(new PacketCompressedNBT(this.data), (EntityPlayerMP)this.getPlayerInv().field_70458_d);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.data = new NBTTagCompound();
        }
    }

    @Override
    public void doAction(EntityPlayerMP player, InventoryAction action, int slot, long id) {
        InvTracker inv = this.byId.get(id);
        if (inv != null) {
            ItemStack is = inv.server.func_70301_a(slot);
            boolean hasItemInHand = !player.field_71071_by.func_70445_o().func_190926_b();
            AdaptorPlayerHand playerHand = new AdaptorPlayerHand((EntityPlayer)player);
            PatternInvSlot slotInv = new PatternInvSlot(inv.server);
            IInventory theSlot = slotInv.getWrapper(slot);
            AdaptorIInventory interfaceSlot = new AdaptorIInventory(theSlot);
            switch (action) {
                case PICKUP_OR_SET_DOWN: {
                    if (hasItemInHand) {
                        ItemStack inSlot = theSlot.func_70301_a(0);
                        if (inSlot.func_190926_b()) {
                            player.field_71071_by.func_70437_b(((InventoryAdaptor)interfaceSlot).addItems(player.field_71071_by.func_70445_o()));
                            break;
                        }
                        inSlot = inSlot.func_77946_l();
                        ItemStack inHand = player.field_71071_by.func_70445_o().func_77946_l();
                        theSlot.func_70299_a(0, ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(ItemStack.field_190927_a);
                        player.field_71071_by.func_70437_b(((InventoryAdaptor)interfaceSlot).addItems(inHand.func_77946_l()));
                        if (player.field_71071_by.func_70445_o().func_190926_b()) {
                            player.field_71071_by.func_70437_b(inSlot);
                            break;
                        }
                        player.field_71071_by.func_70437_b(inHand);
                        theSlot.func_70299_a(0, inSlot);
                        break;
                    }
                    IInventory mySlot = slotInv.getWrapper(slot);
                    mySlot.func_70299_a(0, ((InventoryAdaptor)playerHand).addItems(mySlot.func_70301_a(0)));
                    break;
                }
                case SPLIT_OR_PLACE_SINGLE: {
                    if (hasItemInHand) {
                        ItemStack extra = ((InventoryAdaptor)playerHand).removeItems(1, ItemStack.field_190927_a, null);
                        if (!extra.func_190926_b()) {
                            extra = ((InventoryAdaptor)interfaceSlot).addItems(extra);
                        }
                        if (extra.func_190926_b()) break;
                        ((InventoryAdaptor)playerHand).addItems(extra);
                        break;
                    }
                    if (is.func_190926_b()) break;
                    ItemStack extra = ((InventoryAdaptor)interfaceSlot).removeItems((is.func_190916_E() + 1) / 2, ItemStack.field_190927_a, null);
                    if (!extra.func_190926_b()) {
                        extra = ((InventoryAdaptor)playerHand).addItems(extra);
                    }
                    if (extra.func_190926_b()) break;
                    ((InventoryAdaptor)interfaceSlot).addItems(extra);
                    break;
                }
                case SHIFT_CLICK: {
                    IInventory mySlot = slotInv.getWrapper(slot);
                    InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(player, EnumFacing.UP);
                    mySlot.func_70299_a(0, playerInv.addItems(mySlot.func_70301_a(0)));
                    break;
                }
                case MOVE_REGION: {
                    InventoryAdaptor playerInvAd = InventoryAdaptor.getAdaptor(player, EnumFacing.UP);
                    for (int x = 0; x < inv.server.func_70302_i_(); ++x) {
                        inv.server.func_70299_a(x, playerInvAd.addItems(inv.server.func_70301_a(x)));
                    }
                    break;
                }
                case CREATIVE_DUPLICATE: {
                    if (!player.field_71075_bZ.field_75098_d || hasItemInHand) break;
                    player.field_71071_by.func_70437_b(is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
                    break;
                }
                default: {
                    return;
                }
            }
            this.updateHeld(player);
        }
    }

    private void regenList(NBTTagCompound data) {
        IGridNode agn;
        this.byId.clear();
        this.diList.clear();
        IActionHost host = this.getActionHost();
        if (host != null && (agn = host.getActionableNode()) != null && agn.isActive()) {
            DualityInterface dual;
            IInterfaceHost ih;
            for (IGridNode gn : this.grid.getMachines(TileInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
            for (IGridNode gn : this.grid.getMachines(PartInterface.class)) {
                ih = (IInterfaceHost)gn.getMachine();
                dual = ih.getInterfaceDuality();
                if (!gn.isActive() || dual.getConfigManager().getSetting(Settings.INTERFACE_TERMINAL) != YesNo.YES) continue;
                this.diList.put(ih, new InvTracker(dual, dual.getPatterns(), dual.getTermName()));
            }
        }
        data.func_74757_a("clear", true);
        for (Map.Entry<IInterfaceHost, InvTracker> en : this.diList.entrySet()) {
            InvTracker inv = en.getValue();
            this.byId.put(inv.which, inv);
            this.addItems(data, inv, 0, inv.server.func_70302_i_());
        }
    }

    private boolean isDifferent(ItemStack a, ItemStack b) {
        if (a.func_190926_b() && b.func_190926_b()) {
            return false;
        }
        if (a.func_190926_b() || b.func_190926_b()) {
            return true;
        }
        return !ItemStack.func_77989_b((ItemStack)a, (ItemStack)b);
    }

    private void addItems(NBTTagCompound data, InvTracker inv, int offset, int length) {
        String name = '=' + Long.toString(inv.which, 36);
        NBTTagCompound tag = data.func_74775_l(name);
        if (tag.func_82582_d()) {
            tag.func_74772_a("sortBy", inv.sortBy);
            tag.func_74778_a("un", inv.unlocalizedName);
        }
        for (int x = 0; x < length; ++x) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            ItemStack is = inv.server.func_70301_a(x + offset);
            inv.client.func_70299_a(x + offset, is.func_190926_b() ? ItemStack.field_190927_a : is.func_77946_l());
            if (!is.func_190926_b()) {
                is.func_77955_b(itemNBT);
            }
            tag.func_74782_a(Integer.toString(x + offset), (NBTBase)itemNBT);
        }
        data.func_74782_a(name, (NBTBase)tag);
    }

    static /* synthetic */ long access$508() {
        return autoBase++;
    }

    private static class PatternInvSlot
    extends WrapperInvSlot {
        public PatternInvSlot(IInventory inv) {
            super(inv);
        }

        @Override
        public boolean isItemValid(ItemStack itemstack) {
            return !itemstack.func_190926_b() && itemstack.func_77973_b() instanceof ItemEncodedPattern;
        }
    }

    private static class InvTracker {
        private final long sortBy;
        private final long which = ContainerInterfaceTerminal.access$508();
        private final String unlocalizedName;
        private final IInventory client;
        private final IInventory server;

        public InvTracker(DualityInterface dual, IInventory patterns, String unlocalizedName) {
            this.server = patterns;
            this.client = new AppEngInternalInventory(null, this.server.func_70302_i_());
            this.unlocalizedName = unlocalizedName;
            this.sortBy = dual.getSortValue();
        }
    }
}

