/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.guiobjects.IPortableCell;
import appeng.capabilities.Capabilities;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.util.Platform;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class ContainerMEPortableCell
extends ContainerMEMonitorable {
    private double powerMultiplier = 0.5;
    private final IPortableCell civ;
    private int ticks = 0;
    private final int slot;

    public ContainerMEPortableCell(InventoryPlayer ip, IPortableCell monitorable) {
        super(ip, monitorable, false);
        if (monitorable instanceof IInventorySlotAware) {
            int slotIndex = ((IInventorySlotAware)((Object)monitorable)).getInventorySlot();
            this.lockPlayerInventorySlot(slotIndex);
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        this.civ = monitorable;
        this.bindPlayerInventory(ip, 0, 0);
    }

    private ItemStack getTerminalFromSlot(int slot) {
        IBaublesItemHandler handler;
        if (slot < 0) {
            return this.getPlayerInv().func_70448_g();
        }
        if (slot < this.getPlayerInv().func_70302_i_()) {
            return this.getPlayerInv().func_70301_a(slot);
        }
        if (Capabilities.CAPABILITY_BAUBLES != null && (handler = (IBaublesItemHandler)this.getPlayerInv().field_70458_d.getCapability(Capabilities.CAPABILITY_BAUBLES, null)) != null) {
            return handler.getStackInSlot(slot - this.getPlayerInv().func_70302_i_());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_75142_b() {
        ItemStack currentItem = this.getTerminalFromSlot(this.slot);
        if (this.civ != null) {
            if (currentItem != this.civ.getItemStack()) {
                if (!currentItem.func_190926_b()) {
                    if (Platform.itemComparisons().isEqualItem(this.civ.getItemStack(), currentItem)) {
                        this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.civ.getItemStack());
                    } else {
                        this.setValidContainer(false);
                    }
                } else {
                    this.setValidContainer(false);
                }
            }
        } else {
            this.setValidContainer(false);
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.civ.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.ticks = 0;
        }
        super.func_75142_b();
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }
}

