/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.capabilities.Capabilities;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.core.AEConfig;
import appeng.core.localization.PlayerMessages;
import appeng.helpers.WirelessTerminalGuiObject;
import appeng.util.Platform;
import baubles.api.cap.IBaublesItemHandler;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;

public class ContainerWirelessCraftingTerminal
extends ContainerCraftingTerm {
    private final WirelessTerminalGuiObject wirelessTerminalGUIObject;
    private double powerMultiplier = 0.5;
    private int ticks = 0;
    private final int slot;

    public ContainerWirelessCraftingTerminal(InventoryPlayer ip, WirelessTerminalGuiObject gui) {
        super(ip, gui, false);
        this.wirelessTerminalGUIObject = gui;
        if (gui instanceof IInventorySlotAware) {
            int slotIndex = gui.getInventorySlot();
            this.lockPlayerInventorySlot(slotIndex);
            this.slot = slotIndex;
        } else {
            this.slot = -1;
            this.lockPlayerInventorySlot(ip.field_70461_c);
        }
        this.bindPlayerInventory(ip, 0, 0);
    }

    private ItemStack getTerminalFromSlot(int slot) {
        IBaublesItemHandler handler;
        if (slot < 0) {
            return this.getPlayerInv().func_70448_g();
        }
        if (slot < this.getPlayerInv().func_70302_i_()) {
            return this.getPlayerInv().func_70301_a(slot);
        }
        if (Capabilities.CAPABILITY_BAUBLES != null && (handler = (IBaublesItemHandler)this.getPlayerInv().field_70458_d.getCapability(Capabilities.CAPABILITY_BAUBLES, null)) != null) {
            return handler.getStackInSlot(slot - this.getPlayerInv().func_70302_i_());
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_75142_b() {
        ItemStack currentItem = this.getTerminalFromSlot(this.slot);
        if (this.wirelessTerminalGUIObject != null) {
            if (currentItem != this.wirelessTerminalGUIObject.getItemStack()) {
                if (!currentItem.func_190926_b()) {
                    if (Platform.itemComparisons().isEqualItem(this.wirelessTerminalGUIObject.getItemStack(), currentItem)) {
                        this.getPlayerInv().func_70299_a(this.getPlayerInv().field_70461_c, this.wirelessTerminalGUIObject.getItemStack());
                    } else {
                        this.setValidContainer(false);
                    }
                } else {
                    this.setValidContainer(false);
                }
            }
        } else {
            this.setValidContainer(false);
            return;
        }
        ++this.ticks;
        if (this.ticks > 10) {
            this.wirelessTerminalGUIObject.extractAEPower(this.getPowerMultiplier() * (double)this.ticks, Actionable.MODULATE, PowerMultiplier.CONFIG);
            this.ticks = 0;
        }
        super.func_75142_b();
        if (!this.wirelessTerminalGUIObject.rangeCheck()) {
            if (Platform.isServer() && this.isValidContainer()) {
                this.getPlayerInv().field_70458_d.func_145747_a(PlayerMessages.OutOfRange.get());
            }
            this.setValidContainer(false);
        } else {
            this.setPowerMultiplier(AEConfig.instance().wireless_getDrainRate(this.wirelessTerminalGUIObject.getRange()));
        }
    }

    private double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    void setPowerMultiplier(double powerMultiplier) {
        this.powerMultiplier = powerMultiplier;
    }
}

