/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.api.AEApi;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.CreativeTab;
import appeng.core.CreativeTabFacade;
import appeng.core.FacadeConfig;
import appeng.core.IMCHandler;
import appeng.core.PluginLoader;
import appeng.core.Registration;
import appeng.core.crash.CrashInfo;
import appeng.core.crash.IntegrationCrashEnhancement;
import appeng.core.crash.ModCrashEnhancement;
import appeng.core.features.AEFeature;
import appeng.core.sync.GuiBridge;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.worlddata.WorldData;
import appeng.hooks.TickHandler;
import appeng.integration.IntegrationRegistry;
import appeng.recipes.CustomRecipeConfig;
import appeng.recipes.CustomRecipeForgeConfiguration;
import appeng.server.AECommand;
import appeng.services.export.ExportConfig;
import appeng.services.export.ExportProcess;
import appeng.services.export.ForgeExportConfig;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ICrashCallable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;

@Mod(modid="appliedenergistics2", acceptedMinecraftVersions="[1.12,1.13)", name="Applied Llamagistics", version="rv5-beta-9", dependencies="after:gregtech_addon;after:mekanism;after:ic2;after:thermalexpansion;after:buildcraft;after:opencomputers@[1.7.0,];after:baubles@[1.5.1,];required-after:appliedenergistics2-core;", certificateFingerprint="471969e66a70afa721905d87e393ae397574ebf7", guiFactory="appeng.client.gui.config.AEConfigGuiFactory", updateJSON="https://raw.githubusercontent.com/thiakil/Applied-Energistics-2/rv5-1.12/forge_update.json")
public final class AppEng {
    @SidedProxy(clientSide="appeng.client.ClientHelper", serverSide="appeng.server.ServerHelper", modId="appliedenergistics2")
    public static CommonHelper proxy;
    public static final String MOD_ID = "appliedenergistics2";
    public static final String MOD_NAME = "Applied Llamagistics";
    public static final String ASSETS = "appliedenergistics2:";
    public static final String MOD_DEPENDENCIES = "after:gregtech_addon;after:mekanism;after:ic2;after:thermalexpansion;after:buildcraft;after:opencomputers@[1.7.0,];after:baubles@[1.5.1,];required-after:appliedenergistics2-core;";
    @Nonnull
    private static final AppEng INSTANCE;
    private final Registration registration;
    private File configDirectory;
    private CustomRecipeConfig customRecipeConfig;
    private File recipeDirectory;
    private ExportConfig exportConfig;

    private AppEng() {
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new ModCrashEnhancement(CrashInfo.MOD_VERSION));
        this.registration = new Registration();
    }

    @Nonnull
    @Mod.InstanceFactory
    public static AppEng instance() {
        return INSTANCE;
    }

    @Nonnull
    public final Registration getRegistration() {
        return this.registration;
    }

    @Mod.EventHandler
    private void preInit(FMLPreInitializationEvent event) {
        if (!Loader.isModLoaded((String)"appliedenergistics2-core")) {
            proxy.missingCoreMod();
        }
        Stopwatch watch = Stopwatch.createStarted();
        this.configDirectory = new File(event.getModConfigurationDirectory().getPath(), "AppliedEnergistics2");
        this.recipeDirectory = new File(this.configDirectory, "recipes");
        File configFile = new File(this.configDirectory, "AppliedEnergistics2.cfg");
        File facadeFile = new File(this.configDirectory, "Facades.cfg");
        File recipeFile = new File(this.configDirectory, "CustomRecipes.cfg");
        Configuration recipeConfiguration = new Configuration(recipeFile);
        AEConfig.init(configFile);
        FacadeConfig.init(facadeFile);
        this.customRecipeConfig = new CustomRecipeForgeConfiguration(recipeConfiguration);
        this.exportConfig = new ForgeExportConfig(recipeConfiguration);
        AELog.debug("Pre Initialization ( started )", new Object[0]);
        CreativeTab.init();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.FACADES)) {
            CreativeTabFacade.init();
        }
        this.registration.preInitialize(event, this.recipeDirectory, this.customRecipeConfig);
        proxy.preinit();
        AELog.debug("Pre Initialization ( ended after " + watch.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
        ArrayList injectables = Lists.newArrayList((Object[])new Object[]{AEApi.instance()});
        new PluginLoader().loadPlugins(injectables, event.getAsmData());
        IntegrationRegistry.INSTANCE.preInit();
    }

    private void startService(String serviceName, Thread thread) {
        thread.setName(serviceName);
        thread.setPriority(1);
        AELog.info("Starting " + serviceName, new Object[0]);
        thread.start();
    }

    @Mod.EventHandler
    private void init(FMLInitializationEvent event) {
        Stopwatch start = Stopwatch.createStarted();
        AELog.debug("Initialization ( started )", new Object[0]);
        if (this.exportConfig.isExportingItemNamesEnabled()) {
            if (FMLCommonHandler.instance().getSide().isClient()) {
                ExportProcess process = new ExportProcess(this.recipeDirectory, this.exportConfig);
                Thread exportProcessThread = new Thread(process);
                this.startService("AE2 CSV Export", exportProcessThread);
            } else {
                AELog.info("Disabling item.csv export for custom recipes, since creative tab information is only available on the client.", new Object[0]);
            }
        }
        this.registration.initialize(event);
        IntegrationRegistry.INSTANCE.init();
        proxy.init();
        AELog.debug("Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    private void postInit(FMLPostInitializationEvent event) {
        Stopwatch start = Stopwatch.createStarted();
        AELog.debug("Post Initialization ( started )", new Object[0]);
        this.registration.postInit(event);
        IntegrationRegistry.INSTANCE.postInit();
        FMLCommonHandler.instance().registerCrashCallable((ICrashCallable)new IntegrationCrashEnhancement());
        proxy.postInit();
        AEConfig.instance().save();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)GuiBridge.GUI_Handler);
        NetworkHandler.init("AE2");
        AELog.debug("Post Initialization ( ended after " + start.elapsed(TimeUnit.MILLISECONDS) + "ms )", new Object[0]);
    }

    @Mod.EventHandler
    private void handleIMCEvent(FMLInterModComms.IMCEvent event) {
        IMCHandler imcHandler = new IMCHandler();
        imcHandler.handleIMCEvent(event);
    }

    @Mod.EventHandler
    private void serverAboutToStart(FMLServerAboutToStartEvent evt) {
        WorldData.onServerAboutToStart(evt.getServer());
    }

    @Mod.EventHandler
    private void serverStopping(FMLServerStoppingEvent event) {
        WorldData.instance().onServerStopping();
    }

    @Mod.EventHandler
    private void serverStopped(FMLServerStoppedEvent event) {
        WorldData.instance().onServerStoppped();
        TickHandler.INSTANCE.shutdown();
    }

    @Mod.EventHandler
    private void serverStarting(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new AECommand(evt.getServer()));
    }

    @Mod.EventHandler
    void fingerprintError(FMLFingerprintViolationEvent ev) {
        AELog.error("Fingerprint did not match. En Garde! Be wary of where you got this mod from!", new Object[0]);
        AELog.info("Found signatures:", new Object[0]);
        for (String s : ev.getFingerprints()) {
            AELog.info(s, new Object[0]);
        }
    }

    static {
        INSTANCE = new AppEng();
    }
}

