/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IItems;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.ToolNetworkTool;
import appeng.items.tools.powered.ToolColorApplicator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class PacketClick
extends AppEngPacket {
    private final int x;
    private final int y;
    private final int z;
    private EnumFacing side;
    private final float hitX;
    private final float hitY;
    private final float hitZ;
    private EnumHand hand;

    public PacketClick(ByteBuf stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        byte side = stream.readByte();
        this.side = side != -1 ? EnumFacing.values()[side] : null;
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
        this.hand = EnumHand.values()[stream.readByte()];
    }

    public PacketClick(BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.x = pos.func_177958_n();
        data.writeInt(this.x);
        this.y = pos.func_177956_o();
        data.writeInt(this.y);
        this.z = pos.func_177952_p();
        data.writeInt(this.z);
        if (side == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(side.ordinal());
        }
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        data.writeByte(hand.ordinal());
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        ItemStack is = player.func_184586_b(this.hand);
        IItems items = AEApi.instance().definitions().items();
        IItemDefinition maybeMemoryCard = items.memoryCard();
        IItemDefinition maybeColorApplicator = items.colorApplicator();
        if (!is.func_190926_b()) {
            if (is.func_77973_b() instanceof ToolNetworkTool) {
                ToolNetworkTool tnt = (ToolNetworkTool)is.func_77973_b();
                tnt.serverSideToolLogic(is, player, this.hand, player.field_70170_p, new BlockPos(this.x, this.y, this.z), this.side, this.hitX, this.hitY, this.hitZ);
            } else if (maybeMemoryCard.isSameAs(is)) {
                IMemoryCard mem = (IMemoryCard)is.func_77973_b();
                mem.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                is.func_77982_d(null);
            } else if (maybeColorApplicator.isSameAs(is)) {
                ToolColorApplicator mem = (ToolColorApplicator)is.func_77973_b();
                mem.cycleColors(is, mem.getColor(is), 1);
            }
        }
    }
}

