/*
 * Decompiled with CFR 0.152.
 */
package appeng.decorative.solid;

import appeng.block.AEBaseBlock;
import appeng.core.AELog;
import appeng.core.worlddata.WorldData;
import appeng.util.Platform;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BlockSkyStone
extends AEBaseBlock {
    private static final float BLOCK_RESISTANCE = 150.0f;
    private static final float BREAK_SPEAK_SCALAR = 0.1f;
    private static final double BREAK_SPEAK_THRESHOLD = 7.0;
    private final SkystoneType type;

    public BlockSkyStone(SkystoneType type) {
        super(Material.field_151576_e);
        this.func_149711_c(50.0f);
        this.field_149781_w = 150.0f;
        if (type == SkystoneType.STONE) {
            this.setHarvestLevel("pickaxe", 3);
        }
        this.type = type;
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void breakFaster(PlayerEvent.BreakSpeed event) {
        if (event.getState().func_177230_c() == this && event.getEntityPlayer() != null) {
            ItemStack is = event.getEntityPlayer().func_184582_a(EntityEquipmentSlot.MAINHAND);
            int level = -1;
            if (!is.func_190926_b() && is.func_77973_b() != null) {
                level = is.func_77973_b().getHarvestLevel(is, "pickaxe", event.getEntityPlayer(), event.getState());
            }
            if (this.type != SkystoneType.STONE || level >= 3 || (double)event.getOriginalSpeed() > 7.0) {
                event.setNewSpeed(event.getNewSpeed() / 0.1f);
            }
        }
    }

    public void func_176213_c(World w, BlockPos pos, IBlockState state) {
        super.func_176213_c(w, pos, state);
        assert (pos != null);
        if (Platform.isServer()) {
            if (WorldData.instance() == null) {
                AELog.error("Worlddata was null, server has not started?!", new Object[0]);
                return;
            }
            WorldData.instance().compassData().service().updateArea(w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180663_b(World w, BlockPos pos, IBlockState state) {
        super.func_180663_b(w, pos, state);
        if (Platform.isServer()) {
            if (WorldData.instance() == null) {
                AELog.error("Worlddata was null, server has not started?!", new Object[0]);
                return;
            }
            WorldData.instance().compassData().service().updateArea(w, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static enum SkystoneType {
        STONE,
        BLOCK,
        BRICK,
        SMALL_BRICK;

    }
}

