/*
 * Decompiled with CFR 0.152.
 */
package appeng.entity;

import appeng.api.AEApi;
import appeng.api.definitions.IMaterials;
import appeng.client.EffectType;
import appeng.core.AEConfig;
import appeng.core.AppEng;
import appeng.core.features.AEFeature;
import appeng.entity.AEBaseEntityItem;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public final class EntityChargedQuartz
extends AEBaseEntityItem {
    private int delay = 0;
    private int transformTime = 0;

    public EntityChargedQuartz(World w) {
        super(w);
    }

    public EntityChargedQuartz(World w, double x, double y, double z, ItemStack is) {
        super(w, x, y, z, is);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70128_L || !AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            return;
        }
        if (Platform.isClient() && this.delay > 30 && AEConfig.instance().isEnableEffects()) {
            AppEng.proxy.spawnEffect(EffectType.Lightning, this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, null);
            this.delay = 0;
        }
        ++this.delay;
        int j = MathHelper.func_76128_c((double)this.field_70165_t);
        int i = MathHelper.func_76128_c((double)((this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0));
        int k = MathHelper.func_76128_c((double)this.field_70161_v);
        IBlockState state = this.field_70170_p.func_180495_p(new BlockPos(j, i, k));
        Material mat = state.func_177230_c().func_149688_o(state);
        if (Platform.isServer() && mat.func_76224_d()) {
            ++this.transformTime;
            if (this.transformTime > 60 && !this.transform()) {
                this.transformTime = 0;
            }
        } else {
            this.transformTime = 0;
        }
    }

    private boolean transform() {
        ItemStack item = this.func_92059_d();
        IMaterials materials = AEApi.instance().definitions().materials();
        int redstoneID = OreDictionary.getOreID((String)"dustRedstone");
        int quartzID = OreDictionary.getOreID((String)"gemQuartz");
        ItemStack baseRedstone = new ItemStack(Items.field_151137_ax);
        ItemStack baseQuartz = new ItemStack(Items.field_151128_bU);
        if (materials.certusQuartzCrystalCharged().isSameAs(item)) {
            AxisAlignedBB region = new AxisAlignedBB(this.field_70165_t - 1.0, this.field_70163_u - 1.0, this.field_70161_v - 1.0, this.field_70165_t + 1.0, this.field_70163_u + 1.0, this.field_70161_v + 1.0);
            List<Entity> l = this.getCheckedEntitiesWithinAABBExcludingEntity(region);
            EntityItem redstone = null;
            EntityItem netherQuartz = null;
            block0: for (Entity e : l) {
                ItemStack other;
                if (!(e instanceof EntityItem) || e.field_70128_L || (other = ((EntityItem)e).func_92059_d()).func_190926_b() || other.func_190916_E() <= 0) continue;
                if (Platform.itemComparisons().isEqualItem(other, baseRedstone)) {
                    redstone = (EntityItem)e;
                    continue;
                }
                if (Platform.itemComparisons().isEqualItem(other, baseQuartz)) {
                    netherQuartz = (EntityItem)e;
                    continue;
                }
                int[] otherIDs = OreDictionary.getOreIDs((ItemStack)other);
                if (otherIDs == null) continue;
                for (int id : otherIDs) {
                    if (id == redstoneID) {
                        redstone = (EntityItem)e;
                        continue block0;
                    }
                    if (id != quartzID) continue;
                    netherQuartz = (EntityItem)e;
                    continue block0;
                }
            }
            if (redstone != null && netherQuartz != null) {
                this.func_92059_d().func_190917_f(-1);
                redstone.func_92059_d().func_190917_f(-1);
                netherQuartz.func_92059_d().func_190917_f(-1);
                if (this.func_92059_d().func_190916_E() <= 0) {
                    this.func_70106_y();
                }
                if (redstone.func_92059_d().func_190916_E() <= 0) {
                    redstone.func_70106_y();
                }
                if (netherQuartz.func_92059_d().func_190916_E() <= 0) {
                    netherQuartz.func_70106_y();
                }
                materials.fluixCrystal().maybeStack(2).ifPresent(is -> {
                    EntityItem entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, is);
                    this.field_70170_p.func_72838_d((Entity)entity);
                });
                return true;
            }
        }
        return false;
    }
}

