/*
 * Decompiled with CFR 0.152.
 */
package appeng.facade;

import appeng.api.AEApi;
import appeng.api.parts.IFacadeContainer;
import appeng.api.parts.IFacadePart;
import appeng.api.parts.IPartHost;
import appeng.api.util.AEPartLocation;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.parts.ItemFacade;
import appeng.parts.CableBusStorage;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FacadeContainer
implements IFacadeContainer {
    private final int facades = 6;
    private final CableBusStorage storage;

    public FacadeContainer(CableBusStorage cbs) {
        this.storage = cbs;
    }

    @Override
    public boolean addFacade(IFacadePart a) {
        if (this.getFacade(a.getSide()) == null) {
            this.storage.setFacade(a.getSide().ordinal(), a);
            return true;
        }
        return false;
    }

    @Override
    public void removeFacade(IPartHost host, AEPartLocation side) {
        if (side != null && side != AEPartLocation.INTERNAL && this.storage.getFacade(side.ordinal()) != null) {
            this.storage.setFacade(side.ordinal(), null);
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    @Override
    public IFacadePart getFacade(AEPartLocation s) {
        return this.storage.getFacade(s.ordinal());
    }

    @Override
    public void rotateLeft() {
        FacadePart[] newFacades = new FacadePart[6];
        newFacades[AEPartLocation.UP.ordinal()] = this.storage.getFacade(AEPartLocation.UP.ordinal());
        newFacades[AEPartLocation.DOWN.ordinal()] = this.storage.getFacade(AEPartLocation.DOWN.ordinal());
        newFacades[AEPartLocation.EAST.ordinal()] = this.storage.getFacade(AEPartLocation.NORTH.ordinal());
        newFacades[AEPartLocation.SOUTH.ordinal()] = this.storage.getFacade(AEPartLocation.EAST.ordinal());
        newFacades[AEPartLocation.WEST.ordinal()] = this.storage.getFacade(AEPartLocation.SOUTH.ordinal());
        newFacades[AEPartLocation.NORTH.ordinal()] = this.storage.getFacade(AEPartLocation.WEST.ordinal());
        for (int x = 0; x < this.facades; ++x) {
            this.storage.setFacade(x, newFacades[x]);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound c) {
        for (int x = 0; x < this.facades; ++x) {
            if (this.storage.getFacade(x) == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            this.storage.getFacade(x).getItemStack().func_77955_b(data);
            c.func_74782_a("facade:" + x, (NBTBase)data);
        }
    }

    @Override
    public boolean readFromStream(ByteBuf out) throws IOException {
        byte facadeSides = out.readByte();
        boolean changed = false;
        int[] ids = new int[2];
        for (int x = 0; x < this.facades; ++x) {
            AEPartLocation side = AEPartLocation.fromOrdinal(x);
            int ix = 1 << x;
            if ((facadeSides & ix) == ix) {
                ItemFacade ifa;
                ItemStack facade;
                ids[0] = out.readInt();
                ids[1] = out.readInt();
                ids[0] = Math.abs(ids[0]);
                Optional<Item> maybeFacadeItem = AEApi.instance().definitions().items().facade().maybeItem();
                if (!maybeFacadeItem.isPresent() || (facade = (ifa = (ItemFacade)maybeFacadeItem.get()).createFromIDs(ids)).func_190926_b()) continue;
                changed = changed || this.storage.getFacade(x) == null;
                this.storage.setFacade(x, ifa.createPartFromItemStack(facade, side));
                continue;
            }
            changed = changed || this.storage.getFacade(x) != null;
            this.storage.setFacade(x, null);
        }
        return changed;
    }

    @Override
    public void readFromNBT(NBTTagCompound c) {
        for (int x = 0; x < this.facades; ++x) {
            Item i;
            ItemStack is;
            this.storage.setFacade(x, null);
            NBTTagCompound t = c.func_74775_l("facade:" + x);
            if (t == null || (is = new ItemStack(t)).func_190926_b() || !((i = is.func_77973_b()) instanceof IFacadeItem)) continue;
            this.storage.setFacade(x, ((IFacadeItem)i).createPartFromItemStack(is, AEPartLocation.fromOrdinal(x)));
        }
    }

    @Override
    public void writeToStream(ByteBuf out) throws IOException {
        int x;
        int facadeSides = 0;
        for (x = 0; x < this.facades; ++x) {
            if (this.getFacade(AEPartLocation.fromOrdinal(x)) == null) continue;
            facadeSides |= 1 << x;
        }
        out.writeByte((int)((byte)facadeSides));
        for (x = 0; x < this.facades; ++x) {
            IFacadePart part = this.getFacade(AEPartLocation.fromOrdinal(x));
            if (part == null) continue;
            int itemID = Item.func_150891_b((Item)part.getItem());
            int dmgValue = part.getItemDamage();
            out.writeInt(itemID * (part.notAEFacade() ? -1 : 1));
            out.writeInt(dmgValue);
        }
    }

    @Override
    public boolean isEmpty() {
        for (int x = 0; x < this.facades; ++x) {
            if (this.storage.getFacade(x) == null) continue;
            return false;
        }
        return true;
    }
}

