/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public abstract class AETrading
implements EntityVillager.ITradeList {
    final IMaterials materials = AEApi.instance().definitions().materials();
    @GameRegistry.ObjectHolder(value="minecraft:smith")
    private static VillagerRegistry.VillagerProfession smith;

    public static void registerVillageTrades() {
        if (smith == null) {
            AELog.error("Could not get smith profession.", new Object[0]);
            return;
        }
        VillagerRegistry.VillagerCareer career = new VillagerRegistry.VillagerCareer(smith, "certus");
        career.addTrade(1, new EntityVillager.ITradeList[]{new Lvl1()});
        if (AEConfig.instance().isFeatureEnabled(AEFeature.VILLAGER_TRADING_PRESSES)) {
            career.addTrade(2, new EntityVillager.ITradeList[]{new Presses()});
        }
    }

    private static void addMerchant(@Nonnull MerchantRecipeList list, @Nonnull IItemDefinition item, int emera, Random rand, int greed) {
        item.maybeStack(1).ifPresent(itemStack -> {
            ItemStack from = itemStack.func_77946_l();
            ItemStack to = new ItemStack(Items.field_151166_bC);
            int multiplier = Math.abs(rand.nextInt()) % 6;
            int emeraldCost = emera + Math.abs(rand.nextInt()) % greed - multiplier;
            int mood = rand.nextInt() % 2;
            from.func_190920_e(multiplier + mood);
            to.func_190920_e(multiplier * emeraldCost - mood);
            if (to.func_190916_E() < 0) {
                from.func_190920_e(from.func_190916_E() - to.func_190916_E());
                to.func_190920_e(0);
            }
            AETrading.addToList(list, from, to);
            ItemStack reverseTo = from.func_77946_l();
            ItemStack reverseFrom = to.func_77946_l();
            reverseFrom.func_190920_e((int)((float)reverseFrom.func_190916_E() * rand.nextFloat() * 3.0f + 1.0f));
            AETrading.addToList(list, reverseFrom, reverseTo);
        });
    }

    private static void addTrade(@Nonnull MerchantRecipeList list, IItemDefinition inputDefinition, IItemDefinition outputDefinition, Random rand, int conversionVariance) {
        Optional<ItemStack> maybeInputStack = inputDefinition.maybeStack(1);
        Optional<ItemStack> maybeOutputStack = outputDefinition.maybeStack(1);
        if (maybeInputStack.isPresent() && maybeOutputStack.isPresent()) {
            ItemStack inputStack = maybeInputStack.get().func_77946_l();
            ItemStack outputStack = maybeOutputStack.get().func_77946_l();
            inputStack.func_190920_e(1 + Math.abs(rand.nextInt()) % (1 + conversionVariance));
            outputStack.func_190920_e(1);
            AETrading.addToList(list, inputStack, outputStack);
        }
    }

    private static void addToList(@Nonnull MerchantRecipeList l, ItemStack a, ItemStack b) {
        if (a.func_190916_E() < 1) {
            a.func_190920_e(1);
        }
        if (b.func_190916_E() < 1) {
            b.func_190920_e(1);
        }
        if (a.func_190916_E() > a.func_77976_d()) {
            a.func_190920_e(a.func_77976_d());
        }
        if (b.func_190916_E() > b.func_77976_d()) {
            b.func_190920_e(b.func_77976_d());
        }
        l.add((Object)new MerchantRecipe(a, b));
    }

    private static class Presses
    extends AETrading {
        private Presses() {
        }

        public void func_190888_a(@Nonnull IMerchant villager, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            AETrading.addMerchant(recipeList, this.materials.logicProcessorPress(), 3, random, 2);
            AETrading.addMerchant(recipeList, this.materials.calcProcessorPress(), 4, random, 3);
            AETrading.addMerchant(recipeList, this.materials.engProcessorPress(), 6, random, 4);
        }
    }

    private static class Lvl1
    extends AETrading {
        private Lvl1() {
        }

        public void func_190888_a(@Nonnull IMerchant villager, @Nonnull MerchantRecipeList recipeList, @Nonnull Random random) {
            AETrading.addMerchant(recipeList, this.materials.silicon(), 1, random, 2);
            AETrading.addMerchant(recipeList, this.materials.certusQuartzCrystal(), 2, random, 4);
            AETrading.addMerchant(recipeList, this.materials.certusQuartzDust(), 1, random, 3);
            AETrading.addTrade(recipeList, this.materials.certusQuartzDust(), this.materials.certusQuartzCrystal(), random, 2);
        }
    }
}

