/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.integration.IntegrationNode;
import appeng.integration.IntegrationSide;
import appeng.integration.IntegrationStage;
import appeng.integration.IntegrationType;
import java.util.Collection;
import java.util.LinkedList;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

public enum IntegrationRegistry {
    INSTANCE;

    private final Collection<IntegrationNode> modules = new LinkedList<IntegrationNode>();

    public void add(IntegrationType type) {
        if (type.side == IntegrationSide.CLIENT && FMLLaunchHandler.side() == Side.SERVER) {
            return;
        }
        if (type.side == IntegrationSide.SERVER && FMLLaunchHandler.side() == Side.CLIENT) {
            return;
        }
        this.modules.add(new IntegrationNode(type.dspName, type.modID, type));
    }

    public void preInit() {
        for (IntegrationNode node : this.modules) {
            node.call(IntegrationStage.PRE_INIT);
        }
    }

    public void init() {
        for (IntegrationNode node : this.modules) {
            node.call(IntegrationStage.INIT);
        }
    }

    public void postInit() {
        for (IntegrationNode node : this.modules) {
            node.call(IntegrationStage.POST_INIT);
        }
    }

    public String getStatus() {
        StringBuilder builder = new StringBuilder(this.modules.size() * 3);
        for (IntegrationNode node : this.modules) {
            if (builder.length() != 0) {
                builder.append(", ");
            }
            String integrationState = (Object)((Object)node.getType()) + ":" + (node.getState() == IntegrationStage.FAILED ? "OFF" : "ON");
            builder.append(integrationState);
        }
        return builder.toString();
    }

    public boolean isEnabled(IntegrationType name) {
        for (IntegrationNode node : this.modules) {
            if (node.getType() != name) continue;
            return node.isActive();
        }
        return false;
    }
}

