/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationSide;
import appeng.integration.Integrations;
import appeng.integration.MissingIntegrationModuleException;
import appeng.integration.modules.BuildcraftModule;
import appeng.integration.modules.CofhHammerModule;
import appeng.integration.modules.Mekanism;
import appeng.integration.modules.StorageDrawersModule;
import appeng.integration.modules.chisel.ChiselModule;
import appeng.integration.modules.ic2.IC2Module;
import appeng.integration.modules.jei.JEIModule;
import appeng.integration.modules.opencomputers.OpenComputers;
import appeng.integration.modules.rf.RFItemModule;
import appeng.integration.modules.rf.RFTileModule;
import appeng.integration.modules.theoneprobe.TheOneProbeModule;
import appeng.integration.modules.waila.WailaModule;

public enum IntegrationType {
    IC2(IntegrationSide.BOTH, "Industrial Craft 2", "ic2"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setIc2(new IC2Module());
        }
    }
    ,
    BUILDCRAFT(IntegrationSide.BOTH, "Buildcraft", "buildcraft"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setBc(new BuildcraftModule());
        }
    }
    ,
    COFH_HAMMER(IntegrationSide.BOTH, "TF Hammer", "cofhapi|item"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setCofhHammer(new CofhHammerModule());
        }
    }
    ,
    RF(IntegrationSide.BOTH, "RedstoneFlux Power - Tiles", "cofhapi|energy"){

        @Override
        public IIntegrationModule createInstance() {
            return new RFTileModule();
        }
    }
    ,
    RFItem(IntegrationSide.BOTH, "RedstoneFlux Power - Items", "cofhapi|energy"){

        @Override
        public IIntegrationModule createInstance() {
            return new RFItemModule();
        }
    }
    ,
    Waila(IntegrationSide.BOTH, "Waila", "waila"){

        @Override
        public IIntegrationModule createInstance() {
            return new WailaModule();
        }
    }
    ,
    JEI(IntegrationSide.CLIENT, "Just Enough Items", "jei"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setJei(new JEIModule());
        }
    }
    ,
    OpenComputers(IntegrationSide.BOTH, "OpenComputers", "opencomputers"){

        @Override
        public IIntegrationModule createInstance() {
            return new OpenComputers();
        }
    }
    ,
    THE_ONE_PROBE(IntegrationSide.BOTH, "TheOneProbe", "theoneprobe"){

        @Override
        public IIntegrationModule createInstance() {
            return new TheOneProbeModule();
        }
    }
    ,
    MEKANISM(IntegrationSide.BOTH, "Mekanism", "mekanism"){

        @Override
        public IIntegrationModule createInstance() {
            return Integrations.setMekanism(new Mekanism());
        }
    }
    ,
    CHISEL(IntegrationSide.BOTH, "Chisel", "chisel"){

        @Override
        public IIntegrationModule createInstance() {
            return new ChiselModule();
        }
    }
    ,
    STORAGE_DRAWERS(IntegrationSide.BOTH, "Storage Drawers", "storagedrawers"){

        @Override
        public IIntegrationModule createInstance() {
            return new StorageDrawersModule();
        }
    };

    public final IntegrationSide side;
    public final String dspName;
    public final String modID;

    private IntegrationType(IntegrationSide side, String name, String modid) {
        this.side = side;
        this.dspName = name;
        this.modID = modid;
    }

    public IIntegrationModule createInstance() {
        throw new MissingIntegrationModuleException(this.name());
    }
}

