/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationHelper;
import appeng.me.storage.ITickingMonitor;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.jaquadro.minecraft.storagedrawers.api.capabilities.IItemRepository;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class StorageDrawersModule
implements IIntegrationModule {
    @CapabilityInject(value=IItemRepository.class)
    public static Capability<IItemRepository> ITEM_REPOSITORY_CAPABILITY = null;

    public StorageDrawersModule() {
        IntegrationHelper.testClassExistence(this, IItemRepository.class);
    }

    public static boolean canHandle(ICapabilityProvider provider, EnumFacing side) {
        return ITEM_REPOSITORY_CAPABILITY != null && provider.hasCapability(ITEM_REPOSITORY_CAPABILITY, side);
    }

    public static IMEInventory<IAEItemStack> getHandler(ICapabilityProvider provider, EnumFacing side) {
        if (ITEM_REPOSITORY_CAPABILITY == null) {
            return null;
        }
        IItemRepository repository = (IItemRepository)provider.getCapability(ITEM_REPOSITORY_CAPABILITY, side);
        return repository != null ? new RepositoryInventory(repository) : null;
    }

    private static class RepositoryInventory
    implements IMEInventory<IAEItemStack>,
    IBaseMonitor<IAEItemStack>,
    ITickingMonitor {
        private final IItemRepository repo;
        private final Map<IMEMonitorHandlerReceiver<IAEItemStack>, Object> listeners = new HashMap<IMEMonitorHandlerReceiver<IAEItemStack>, Object>();
        private BaseActionSource mySource;
        private ItemStack[] cachedStacks = new ItemStack[0];
        private IAEItemStack[] cachedAeStacks = new IAEItemStack[0];

        RepositoryInventory(IItemRepository r) {
            this.repo = r;
        }

        @Override
        public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
            AEItemStack res = AEItemStack.create(this.repo.insertItem(input.getItemStack(), type == Actionable.SIMULATE));
            if (type == Actionable.MODULATE) {
                this.onTick(input.getItemStack());
            }
            return res;
        }

        @Override
        public IAEItemStack extractItems(IAEItemStack request, Actionable type, BaseActionSource src) {
            AEItemStack res = AEItemStack.create(this.repo.extractItem(request.getItemStack(), (int)request.getStackSize(), type == Actionable.SIMULATE));
            if (type == Actionable.MODULATE) {
                this.onTick(request.getItemStack());
            }
            return res;
        }

        @Override
        public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
            NonNullList list = this.repo.getAllItems();
            for (IItemRepository.ItemRecord record : list) {
                AEItemStack aeStack = AEItemStack.create(record.itemPrototype);
                if (aeStack == null) continue;
                aeStack.setStackSize(record.count);
                out.add(aeStack);
            }
            return out;
        }

        @Override
        public StorageChannel getChannel() {
            return StorageChannel.ITEMS;
        }

        @Override
        public TickRateModulation onTick() {
            return this.onTick(null);
        }

        public TickRateModulation onTick(@Nullable ItemStack expectedChange) {
            int slot;
            LinkedList<IAEItemStack> changes = new LinkedList<IAEItemStack>();
            NonNullList repoList = this.repo.getAllItems();
            int slots = repoList.size();
            if (slots > this.cachedStacks.length) {
                this.cachedStacks = Arrays.copyOf(this.cachedStacks, slots);
                for (int i = 0; i < this.cachedStacks.length; ++i) {
                    if (this.cachedStacks[i] != null) continue;
                    this.cachedStacks[i] = ItemStack.field_190927_a;
                }
                this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
            }
            for (slot = 0; slot < slots; ++slot) {
                ItemStack oldIS = this.cachedStacks[slot];
                IAEItemStack oldAeIS = this.cachedAeStacks[slot];
                ItemStack newIS = ((IItemRepository.ItemRecord)repoList.get((int)slot)).itemPrototype.func_77946_l();
                newIS.func_190920_e(((IItemRepository.ItemRecord)repoList.get((int)slot)).count);
                if (expectedChange != null && !Platform.itemComparisons().isSameItem(newIS, expectedChange) && !Platform.itemComparisons().isSameItem(oldIS, expectedChange)) continue;
                if (this.isDifferent(newIS, oldIS)) {
                    this.addItemChange(slot, oldAeIS, newIS, changes);
                    continue;
                }
                if (newIS.func_190926_b() || oldIS.func_190926_b()) continue;
                this.addPossibleStackSizeChange(slot, oldAeIS, newIS, changes);
            }
            if (slots < this.cachedStacks.length) {
                for (slot = slots; slot < this.cachedStacks.length; ++slot) {
                    IAEItemStack aeStack = this.cachedAeStacks[slot];
                    if (aeStack == null) continue;
                    IAEItemStack a = aeStack.copy();
                    a.setStackSize(-a.getStackSize());
                    changes.add(a);
                }
                this.cachedStacks = Arrays.copyOf(this.cachedStacks, slots);
                this.cachedAeStacks = Arrays.copyOf(this.cachedAeStacks, slots);
            }
            if (!changes.isEmpty()) {
                this.postDifference(changes);
                return TickRateModulation.URGENT;
            }
            return TickRateModulation.SLOWER;
        }

        private void addItemChange(int slot, IAEItemStack oldAeIS, ItemStack newIS, List<IAEItemStack> changes) {
            this.cachedStacks[slot] = newIS;
            this.cachedAeStacks[slot] = AEItemStack.create(newIS);
            if (oldAeIS != null) {
                oldAeIS.setStackSize(-oldAeIS.getStackSize());
                changes.add(oldAeIS);
            }
            if (this.cachedAeStacks[slot] != null) {
                changes.add(this.cachedAeStacks[slot]);
            }
        }

        private void addPossibleStackSizeChange(int slot, IAEItemStack oldAeIS, ItemStack newIS, List<IAEItemStack> changes) {
            long diff = (long)newIS.func_190916_E() - oldAeIS.getStackSize();
            if (diff != 0L) {
                IAEItemStack stack = oldAeIS.copy();
                stack.setStackSize(newIS.func_190916_E());
                this.cachedStacks[slot] = newIS;
                this.cachedAeStacks[slot] = stack;
                IAEItemStack a = stack.copy();
                a.setStackSize(diff);
                changes.add(a);
            }
        }

        private boolean isDifferent(ItemStack a, ItemStack b) {
            if (a == b && b.func_190926_b()) {
                return false;
            }
            return a.func_190926_b() || b.func_190926_b() || !Platform.itemComparisons().isSameItem(a, b);
        }

        private void postDifference(Iterable<IAEItemStack> a) {
            Iterator<Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object>> i = this.listeners.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<IMEMonitorHandlerReceiver<IAEItemStack>, Object> l = i.next();
                IMEMonitorHandlerReceiver<IAEItemStack> key = l.getKey();
                if (key.isValid(l.getValue())) {
                    key.postChange(this, a, this.mySource);
                    continue;
                }
                i.remove();
            }
        }

        @Override
        public void setActionSource(BaseActionSource mySource) {
            this.mySource = mySource;
        }

        @Override
        public void addListener(IMEMonitorHandlerReceiver<IAEItemStack> l, Object verificationToken) {
            this.listeners.put(l, verificationToken);
        }

        @Override
        public void removeListener(IMEMonitorHandlerReceiver<IAEItemStack> l) {
            this.listeners.remove(l);
        }
    }
}

