/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IInscriberRecipe;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.integration.Integrations;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.CondenserOutputHandler;
import appeng.integration.modules.jei.FacadeRegistryPlugin;
import appeng.integration.modules.jei.GrinderRecipeCategory;
import appeng.integration.modules.jei.GrinderRecipeHandler;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.InscriberRecipeHandler;
import appeng.integration.modules.jei.JEIModule;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.RecipeTransferHandler;
import appeng.integration.modules.jei.ShapedRecipeHandler;
import appeng.integration.modules.jei.ShapelessRecipeHandler;
import appeng.items.parts.ItemFacade;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import mezz.jei.api.BlankModPlugin;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
extends BlankModPlugin {
    public void register(IModRegistry registry) {
        registry.handleRecipes(ShapedRecipeHandler.getRecipeClass(), (IRecipeWrapperFactory)new ShapedRecipeHandler(), ShapedRecipeHandler.getRecipeCategoryUid());
        registry.handleRecipes(ShapelessRecipeHandler.getRecipeClass(), (IRecipeWrapperFactory)new ShapelessRecipeHandler(), ShapelessRecipeHandler.getRecipeCategoryUid());
        IDefinitions definitions = AEApi.instance().definitions();
        this.registerFacadeRecipe(definitions, registry);
        this.registerInscriberRecipes(definitions, registry);
        this.registerCondenserRecipes(definitions, registry);
        this.registerGrinderRecipes(definitions, registry);
        this.registerDescriptions(definitions, registry);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerCraftingTerm>(ContainerCraftingTerm.class), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerPatternTerm>(ContainerPatternTerm.class), "minecraft.crafting");
    }

    private void registerDescriptions(IDefinitions definitions, IModRegistry registry) {
        IMaterials materials = definitions.materials();
        if (AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN)) {
            this.addDescription(registry, materials.certusQuartzCrystalCharged(), GuiText.ChargedQuartz.getUnlocalized(), GuiText.ChargedQuartzFind.getUnlocalized());
        } else {
            this.addDescription(registry, materials.certusQuartzCrystalCharged(), GuiText.ChargedQuartzFind.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            this.addDescription(registry, materials.logicProcessorPress(), GuiText.inWorldCraftingPresses.getUnlocalized());
            this.addDescription(registry, materials.calcProcessorPress(), GuiText.inWorldCraftingPresses.getUnlocalized());
            this.addDescription(registry, materials.engProcessorPress(), GuiText.inWorldCraftingPresses.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            this.addDescription(registry, materials.fluixCrystal(), GuiText.inWorldFluix.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_SINGULARITY)) {
            this.addDescription(registry, materials.qESingularity(), GuiText.inWorldSingularity.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            this.addDescription(registry, materials.purifiedCertusQuartzCrystal(), GuiText.inWorldPurificationCertus.getUnlocalized());
            this.addDescription(registry, materials.purifiedNetherQuartzCrystal(), GuiText.inWorldPurificationNether.getUnlocalized());
            this.addDescription(registry, materials.purifiedFluixCrystal(), GuiText.inWorldPurificationFluix.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_ME)) {
            this.addDescription(registry, definitions.parts().p2PTunnelME(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneME.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_ITEMS)) {
            this.addDescription(registry, definitions.parts().p2PTunnelItems(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneItem.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_REDSTONE)) {
            this.addDescription(registry, definitions.parts().p2PTunnelRedstone(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneRedstone.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_EU)) {
            this.addDescription(registry, definitions.parts().p2PTunnelEU(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneIC2.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_FLUIDS)) {
            this.addDescription(registry, definitions.parts().p2PTunnelFluids(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneFluid.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_LIGHT)) {
            this.addDescription(registry, definitions.parts().p2PTunnelLight(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneLight.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_OPEN_COMPUTERS)) {
            this.addDescription(registry, definitions.parts().p2PTunnelOpenComputers(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneOC.getUnlocalized());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.P2P_TUNNEL_FE)) {
            this.addDescription(registry, definitions.parts().p2PTunnelFE(), GuiText.AttuneGeneric.getUnlocalized(), " ", GuiText.AttuneForgeEnergy.getUnlocalized());
        }
    }

    private void addDescription(IModRegistry registry, IItemDefinition itemDefinition, String ... message) {
        itemDefinition.maybeStack(1).ifPresent(itemStack -> registry.addIngredientInfo(itemStack, ItemStack.class, message));
    }

    private void registerGrinderRecipes(IDefinitions definitions, IModRegistry registry) {
        ItemStack grindstone = definitions.blocks().grindstone().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (grindstone.func_190926_b()) {
            return;
        }
        registry.addRecipes((Collection)Lists.newArrayList(AEApi.instance().registries().grinder().getRecipes()), "appliedenergistics2.grinder");
        registry.handleRecipes(IGrinderRecipe.class, (IRecipeWrapperFactory)new GrinderRecipeHandler(), "appliedenergistics2.grinder");
        registry.addRecipeCatalyst((Object)grindstone, new String[]{"appliedenergistics2.grinder"});
    }

    private void registerCondenserRecipes(IDefinitions definitions, IModRegistry registry) {
        ItemStack singularity;
        ItemStack condenser = definitions.blocks().condenser().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (condenser.func_190926_b()) {
            return;
        }
        ItemStack matterBall = definitions.materials().matterBall().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!matterBall.func_190926_b()) {
            registry.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.MATTER_BALLS)), CondenserOutputHandler.getRecipeCategoryUid());
        }
        if (!(singularity = definitions.materials().singularity().maybeStack(1).orElse(ItemStack.field_190927_a)).func_190926_b()) {
            registry.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.SINGULARITY)), CondenserOutputHandler.getRecipeCategoryUid());
        }
        if (!matterBall.func_190926_b() || !singularity.func_190926_b()) {
            registry.addRecipeCatalyst((Object)condenser, new String[]{"appliedenergistics2.condenser"});
            registry.handleRecipes(CondenserOutput.class, (IRecipeWrapperFactory)new CondenserOutputHandler(registry.getJeiHelpers().getGuiHelper(), matterBall, singularity), CondenserOutputHandler.getRecipeCategoryUid());
        }
    }

    private void registerInscriberRecipes(IDefinitions definitions, IModRegistry registry) {
        registry.handleRecipes(InscriberRecipeHandler.getRecipeClass(), (IRecipeWrapperFactory)new InscriberRecipeHandler(), InscriberRecipeHandler.getRecipeCategoryUid());
        definitions.blocks().inscriber().maybeStack(1).ifPresent(inscriber -> registry.addRecipeCatalyst(inscriber, new String[]{"appliedenergistics2.inscriber"}));
        ArrayList<IInscriberRecipe> inscriberRecipes = new ArrayList<IInscriberRecipe>(AEApi.instance().registries().inscriber().getRecipes());
        registry.addRecipes(inscriberRecipes, InscriberRecipeHandler.getRecipeCategoryUid());
    }

    private void registerFacadeRecipe(IDefinitions definitions, IModRegistry registry) {
        Optional<Item> itemFacade = definitions.items().facade().maybeItem();
        Optional<ItemStack> cableAnchor = definitions.parts().cableAnchor().maybeStack(1);
        if (itemFacade.isPresent() && cableAnchor.isPresent()) {
            registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new FacadeRegistryPlugin((ItemFacade)itemFacade.get(), cableAnchor.get()));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIModule jeiModule = (JEIModule)Integrations.jei();
        jeiModule.setJei(new JeiRuntimeAdapter(jeiRuntime));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IDefinitions definitions = AEApi.instance().definitions();
        ItemStack grindstone = definitions.blocks().grindstone().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!grindstone.func_190926_b()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new GrinderRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        }
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriberRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        ItemStack condenser = definitions.blocks().condenser().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!condenser.func_190926_b()) {
            registry.addRecipeCategories(new IRecipeCategory[]{new CondenserCategory(registry.getJeiHelpers().getGuiHelper())});
        }
    }
}

