/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketJEIRecipe;
import appeng.util.Platform;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

class RecipeTransferHandler<T extends Container>
implements IRecipeTransferHandler<T> {
    private final Class<T> containerClass;

    RecipeTransferHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public Class<T> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(T container, IRecipeLayout recipeLayout, EntityPlayer player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        Map ingredients = recipeLayout.getItemStacks().getGuiIngredients();
        NBTTagCompound recipe = new NBTTagCompound();
        int slotIndex = 0;
        for (Map.Entry ingredientEntry : ingredients.entrySet()) {
            IGuiIngredient ingredient = (IGuiIngredient)ingredientEntry.getValue();
            if (!ingredient.isInput()) continue;
            for (Slot slot : ((Container)container).field_75151_b) {
                if (!(slot instanceof SlotCraftingMatrix) && !(slot instanceof SlotFakeCraftingMatrix) || slot.getSlotIndex() != slotIndex) continue;
                NBTTagList tags = new NBTTagList();
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (ItemStack stack : ingredient.getAllIngredients()) {
                    if (Platform.isRecipePrioritized(stack)) {
                        list.add(0, stack);
                        continue;
                    }
                    list.add(stack);
                }
                for (ItemStack is : list) {
                    NBTTagCompound tag = new NBTTagCompound();
                    is.func_77955_b(tag);
                    tags.func_74742_a((NBTBase)tag);
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                break;
            }
            ++slotIndex;
        }
        try {
            NetworkHandler.instance().sendToServer(new PacketJEIRecipe(recipe));
        }
        catch (IOException e) {
            AELog.debug(e);
        }
        return null;
    }
}

