/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers;

import appeng.api.AEApi;
import appeng.api.storage.ICellInventory;
import appeng.api.storage.ICellInventoryHandler;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import java.util.Map;
import li.cil.oc.api.driver.Converter;
import net.minecraft.item.ItemStack;

public final class ConverterCellInventory
implements Converter {
    public static void convertCellInv(ICellInventory cell, Map<Object, Object> output) {
        output.put("storedItemTypes", cell.getStoredItemTypes());
        output.put("storedItemCount", cell.getStoredItemCount());
        output.put("remainingItemCount", cell.getRemainingItemCount());
        output.put("remainingItemTypes", cell.getRemainingItemTypes());
        output.put("getTotalItemTypes", cell.getTotalItemTypes());
        output.put("totalBytes", cell.getTotalBytes());
        output.put("freeBytes", cell.getFreeBytes());
        output.put("usedBytes", cell.getUsedBytes());
        output.put("unusedItemCount", cell.getUnusedItemCount());
        output.put("canHoldNewItem", cell.canHoldNewItem());
        output.put("fuzzyMode", cell.getFuzzyMode().toString());
        output.put("name", cell.getItemStack().func_82833_r());
    }

    public void convert(Object value, Map<Object, Object> output) {
        if (value instanceof ICellInventory) {
            ICellInventory cell = (ICellInventory)value;
            ConverterCellInventory.convertCellInv(cell, output);
        } else if (value instanceof ICellInventoryHandler) {
            this.convert(((ICellInventoryHandler)value).getCellInv(), output);
        } else if (value instanceof ItemStack) {
            IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory((ItemStack)value, null, StorageChannel.ITEMS);
            if (handler == null) {
                handler = AEApi.instance().registries().cell().getCellInventory((ItemStack)value, null, StorageChannel.FLUIDS);
            }
            if (handler != null && handler instanceof ICellInventoryHandler) {
                this.convert(handler, output);
            }
        }
    }
}

