/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingCPU;
import appeng.api.networking.crafting.ICraftingCallback;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.security.MachineSource;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.CraftingStatus;
import appeng.integration.modules.opencomputers.SaveableGridProxy;
import appeng.me.GridAccessException;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractValue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class Craftable
extends AbstractValue
implements ICraftingRequester {
    protected SaveableGridProxy gridProxy = null;
    protected IAEItemStack[] condensedOutputs;
    protected IAEItemStack output;
    protected ArrayList<ICraftingLink> links = new ArrayList();

    public Craftable() {
    }

    public Craftable(SaveableGridProxy gridProxy, ICraftingPatternDetails pattern, IAEItemStack output) {
        this.gridProxy = gridProxy;
        this.output = output;
        this.condensedOutputs = pattern.getCondensedOutputs();
    }

    @Callback(doc="function():table -- Returns the item stack representation of the crafting result (primary output).")
    public Object[] getItemStack(Context context, Arguments args) {
        return new Object[]{this.output.getItemStack()};
    }

    @Callback(doc="function():table -- Returns the item stack representation of the complete crafting result (all outputs).")
    public Object[] getOutputs(Context context, Arguments args) {
        try {
            ItemStack[] outputs = new ItemStack[this.condensedOutputs.length];
            for (int i = 0; i < this.condensedOutputs.length; ++i) {
                outputs[i] = this.condensedOutputs[i].getItemStack();
            }
            return new Object[]{outputs};
        }
        catch (Exception e) {
            AELog.error("Unknown error accessing outputs.", e);
            return new Object[]{null, "Unknown internal error."};
        }
    }

    @Callback(doc="function([amount:int[, prioritizePower:boolean[, cpuName:string]]]):userdata -- Requests the item to be crafted, returning an object that allows tracking the crafting status.")
    public Object[] request(Context context, Arguments args) {
        int count = args.optInteger(0, 1);
        final boolean prioritizePower = args.optBoolean(1, true);
        String cpuName = args.optString(2, "");
        final MachineSource source = new MachineSource(this);
        IAEItemStack request = this.output.copy();
        request.setStackSize(count);
        final CraftingStatus returnStatus = new CraftingStatus();
        try {
            final ICraftingGrid craftingGrid = this.gridProxy.getProxy().getCrafting();
            ICraftingCPU wantedCPU = null;
            if (!cpuName.isEmpty()) {
                ImmutableSet<ICraftingCPU> cpus = this.gridProxy.getProxy().getCrafting().getCpus();
                for (ICraftingCPU cpu : cpus) {
                    if (!cpu.getName().equals(cpuName)) continue;
                    wantedCPU = cpu;
                    break;
                }
            }
            final ICraftingCPU finalCPU = wantedCPU;
            Object object = craftingGrid.beginCraftingJob(this.gridProxy.getProxy().getNode().getWorld(), this.gridProxy.getProxy().getGrid(), source, request, new ICraftingCallback(){

                @Override
                public void calculationComplete(ICraftingJob job) {
                    try {
                        ICraftingLink link = craftingGrid.submitJob(job, Craftable.this, finalCPU, prioritizePower, source);
                        if (link != null) {
                            returnStatus.setLink(link);
                            Craftable.this.links.add(link);
                        } else {
                            returnStatus.fail("could not submit crafting job.");
                        }
                    }
                    catch (Exception e) {
                        AELog.error("Error submitting job to AE2.", e);
                        returnStatus.fail(e.toString());
                    }
                }
            });
        }
        catch (GridAccessException e) {
            return new Object[]{null, "Error accessing grid."};
        }
        catch (Exception e) {
            AELog.error("Unknown error accessing ME net.", e);
            return new Object[]{null, "Unknown internal error."};
        }
        return new Object[]{returnStatus};
    }

    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("gridproxy")) {
            this.gridProxy = new SaveableGridProxy();
            this.gridProxy.load(nbt.func_74775_l("gridproxy"));
        }
        if (nbt.func_74764_b("output")) {
            this.output = AEItemStack.loadItemStackFromNBT(nbt.func_74775_l("output"));
        }
        if (nbt.func_74764_b("condensed_output")) {
            NBTTagList list = nbt.func_150295_c("condensed_output", (int)nbt.func_74732_a());
            this.condensedOutputs = new IAEItemStack[list.func_74745_c()];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.condensedOutputs[i] = AEItemStack.loadItemStackFromNBT(list.func_150305_b(i));
            }
        }
    }

    public void save(NBTTagCompound nbt) {
        super.save(nbt);
        nbt.func_74782_a("gridproxy", (NBTBase)this.gridProxy.save());
        NBTTagCompound stackNBTOutput = new NBTTagCompound();
        this.output.writeToNBT(stackNBTOutput);
        nbt.func_74782_a("output", (NBTBase)stackNBTOutput);
        NBTTagList condensed = new NBTTagList();
        for (IAEItemStack stack : this.condensedOutputs) {
            if (stack == null) continue;
            NBTTagCompound stackNBT = new NBTTagCompound();
            stack.writeToNBT(stackNBT);
            condensed.func_74742_a((NBTBase)stackNBT);
        }
        nbt.func_74782_a("condensed_output", (NBTBase)condensed);
    }

    @Override
    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        return ImmutableSet.of();
    }

    @Override
    public IAEItemStack injectCraftedItems(ICraftingLink iCraftingLink, IAEItemStack iaeItemStack, Actionable actionable) {
        return iaeItemStack;
    }

    @Override
    public void jobStateChange(ICraftingLink iCraftingLink) {
        this.links.remove(iCraftingLink);
    }

    @Override
    public IGridNode getActionableNode() {
        return this.gridProxy.getProxy().getNode();
    }

    @Override
    public IGridNode getGridNode(AEPartLocation aePartLocation) {
        return this.gridProxy.getProxy().getNode();
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation aePartLocation) {
        return this.gridProxy.getGridProxyable() != null ? this.gridProxy.getGridProxyable().getCableConnectionType(aePartLocation) : null;
    }

    @Override
    public void securityBreak() {
        if (this.gridProxy.getGridProxyable() != null) {
            this.gridProxy.getGridProxyable().securityBreak();
        }
    }
}

