/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers;

import appeng.integration.modules.opencomputers.Converters;
import java.util.HashMap;
import java.util.TreeMap;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.prefab.AbstractValue;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ItemStackArrayValue
extends AbstractValue {
    private ItemStack[] array = null;
    private int iteratorIndex;
    private static final byte TAGLIST_ID = new NBTTagList().func_74732_a();
    private static final byte COMPOUND_ID = new NBTTagCompound().func_74732_a();
    private static final String ARRAY_KEY = "Array";
    private static final String INDEX_KEY = "Index";
    private static final HashMap<Object, Object> emptyMap = new HashMap();

    public ItemStackArrayValue(ItemStack[] arr) {
        if (arr != null) {
            this.array = new ItemStack[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                this.array[i] = arr[i] != null ? arr[i].func_77946_l() : null;
            }
        }
        this.iteratorIndex = 0;
    }

    public ItemStackArrayValue() {
        this(null);
    }

    public Object[] call(Context context, Arguments arguments) {
        int index;
        if (this.array == null) {
            return null;
        }
        if (this.iteratorIndex >= this.array.length) {
            return null;
        }
        if (this.array[index = this.iteratorIndex++] == null || this.array[index].func_190926_b()) {
            return new Object[]{emptyMap};
        }
        return new Object[]{Converters.convert(this.array[index])};
    }

    public Object apply(Context context, Arguments arguments) {
        String arg;
        if (arguments.count() == 0 || this.array == null) {
            return null;
        }
        if (arguments.isInteger(0)) {
            int luaIndex = arguments.checkInteger(0);
            if (luaIndex > this.array.length || luaIndex < 1) {
                return null;
            }
            return Converters.convert(this.array[luaIndex - 1]);
        }
        if (arguments.isString(0) && (arg = arguments.checkString(0)).equals("n")) {
            return this.array.length;
        }
        return null;
    }

    public void load(NBTTagCompound nbt) {
        if (nbt.func_150297_b(ARRAY_KEY, (int)TAGLIST_ID)) {
            NBTTagList tagList = nbt.func_150295_c(ARRAY_KEY, (int)COMPOUND_ID);
            this.array = new ItemStack[tagList.func_74745_c()];
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound el = tagList.func_150305_b(i);
                this.array[i] = el.func_82582_d() ? null : new ItemStack(el);
            }
        } else {
            this.array = null;
        }
        this.iteratorIndex = nbt.func_74762_e(INDEX_KEY);
    }

    public void save(NBTTagCompound nbt) {
        NBTTagCompound nullnbt = new NBTTagCompound();
        if (this.array != null) {
            NBTTagList nbttaglist = new NBTTagList();
            for (ItemStack stack : this.array) {
                if (stack != null && !stack.func_190926_b()) {
                    NBTTagCompound nbttagcompound = stack.serializeNBT();
                    nbttaglist.func_74742_a((NBTBase)nbttagcompound);
                    continue;
                }
                nbttaglist.func_74742_a((NBTBase)nullnbt);
            }
            nbt.func_74782_a(ARRAY_KEY, (NBTBase)nbttaglist);
        }
        nbt.func_74768_a(INDEX_KEY, this.iteratorIndex);
    }

    @Callback(doc="function():nil -- Reset the iterator index so that the next call will return the first element.")
    public Object[] reset(Context context, Arguments arguments) throws Exception {
        this.iteratorIndex = 0;
        return null;
    }

    @Callback(doc="function():number -- Returns the number of elements in the array.")
    public Object[] count(Context context, Arguments arguments) throws Exception {
        return new Object[]{this.array != null ? this.array.length : 0};
    }

    @Callback(doc="function():table -- Returns ALL the stacks in the array. Memory intensive.")
    public Object[] getAll(Context context, Arguments arguments) throws Exception {
        TreeMap<Integer, ItemStack> map = new TreeMap<Integer, ItemStack>();
        for (int i = 0; i < this.array.length; ++i) {
            map.put(i, this.array[i] != null && !this.array[i].func_190926_b() ? this.array[i] : emptyMap);
        }
        return new Object[]{Converters.convert(map)};
    }

    public String toString() {
        return "{ItemStack Array}";
    }
}

