/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.opencomputers.driver;

import appeng.api.AEApi;
import appeng.core.AELog;
import appeng.integration.modules.opencomputers.SaveableGridProxy;
import appeng.integration.modules.opencomputers.driver.InterfaceDriver;
import appeng.integration.modules.opencomputers.environment.MENetworkEnvironment;
import appeng.me.helpers.IGridProxyable;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.network.ManagedEnvironment;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NetworkDriver
implements DriverBlock {
    public boolean worksWith(World world, BlockPos pos, EnumFacing side) {
        try {
            return AEApi.instance().definitions().blocks().controller().isSameAs((IBlockAccess)world, pos) || InterfaceDriver.isInterface(world, pos, side);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static IGridProxyable getGridProxyable(World world, BlockPos pos, EnumFacing side) {
        try {
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null) {
                if (tile instanceof IGridProxyable) {
                    return (IGridProxyable)tile;
                }
                return InterfaceDriver.getIfaceGrid(tile, side);
            }
        }
        catch (Exception e) {
            AELog.error("Error occurred during MENetworkEnvironment creation.", e);
        }
        return null;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos pos, EnumFacing side) {
        IGridProxyable proxyable;
        if (this.worksWith(world, pos, side) && (proxyable = NetworkDriver.getGridProxyable(world, pos, side)) != null) {
            return new MENetworkEnvironment(new SaveableGridProxy(proxyable, side), world);
        }
        return null;
    }
}

