/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.misc;

import appeng.api.AEApi;
import appeng.api.implementations.ICraftingPatternItem;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.storage.data.IAEItemStack;
import appeng.core.AppEng;
import appeng.core.localization.GuiText;
import appeng.helpers.PatternHelper;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemEncodedPattern
extends AEBaseItem
implements ICraftingPatternItem {
    private static final Map<ItemStack, ItemStack> SIMPLE_CACHE = new WeakHashMap<ItemStack, ItemStack>();

    public ItemEncodedPattern() {
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        this.clearPattern(player.func_184586_b(hand), player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return this.clearPattern(player.func_184586_b(hand), player) ? EnumActionResult.SUCCESS : EnumActionResult.PASS;
    }

    private boolean clearPattern(ItemStack stack, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (Platform.isClient()) {
                return false;
            }
            InventoryPlayer inv = player.field_71071_by;
            ItemStack is = AEApi.instance().definitions().materials().blankPattern().maybeStack(stack.func_190916_E()).orElse(ItemStack.field_190927_a);
            if (!is.func_190926_b()) {
                for (int s = 0; s < player.field_71071_by.func_70302_i_(); ++s) {
                    if (inv.func_70301_a(s) != stack) continue;
                    inv.func_70299_a(s, is);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, boolean displayMoreInfo) {
        ICraftingPatternDetails details = this.getPatternForItem(stack, world);
        if (details == null) {
            lines.add(TextFormatting.RED + GuiText.InvalidPattern.getLocal());
            return;
        }
        boolean isCrafting = details.isCraftable();
        boolean substitute = details.canSubstitute();
        IAEItemStack[] in = details.getCondensedInputs();
        IAEItemStack[] out = details.getCondensedOutputs();
        String label = (isCrafting ? GuiText.Crafts.getLocal() : GuiText.Creates.getLocal()) + ": ";
        String and = ' ' + GuiText.And.getLocal() + ' ';
        String with = GuiText.With.getLocal() + ": ";
        boolean first = true;
        for (IAEItemStack anOut : out) {
            if (anOut == null) continue;
            lines.add((first ? label : and) + anOut.getStackSize() + ' ' + Platform.getItemDisplayName(anOut));
            first = false;
        }
        first = true;
        for (IAEItemStack anIn : in) {
            if (anIn == null) continue;
            lines.add((first ? with : and) + anIn.getStackSize() + ' ' + Platform.getItemDisplayName(anIn));
            first = false;
        }
        if (isCrafting) {
            String substitutionLabel = GuiText.Substitute.getLocal() + " ";
            String canSubstitute = substitute ? GuiText.Yes.getLocal() : GuiText.No.getLocal();
            lines.add(substitutionLabel + canSubstitute);
        }
    }

    @Override
    public ICraftingPatternDetails getPatternForItem(ItemStack is, World w) {
        try {
            return new PatternHelper(is, w);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public ItemStack getOutput(ItemStack item) {
        ItemStack out = SIMPLE_CACHE.get(item);
        if (out != null && !out.func_190926_b()) {
            return out;
        }
        World w = AppEng.proxy.getWorld();
        if (w == null) {
            return ItemStack.field_190927_a;
        }
        ICraftingPatternDetails details = this.getPatternForItem(item, w);
        if (details == null) {
            return ItemStack.field_190927_a;
        }
        out = details.getCondensedOutputs()[0].getItemStack();
        SIMPLE_CACHE.put(item, out);
        return out;
    }
}

