/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.parts;

import appeng.api.AEApi;
import appeng.api.exceptions.MissingDefinition;
import appeng.api.parts.IAlphaPassItem;
import appeng.api.util.AEPartLocation;
import appeng.core.AELog;
import appeng.core.FacadeConfig;
import appeng.decorative.solid.BlockQuartzOre;
import appeng.facade.FacadePart;
import appeng.facade.IFacadeItem;
import appeng.items.AEBaseItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class ItemFacade
extends AEBaseItem
implements IFacadeItem,
IAlphaPassItem {
    private static final String TAG_ITEM_ID = "item";
    private static final String TAG_DAMAGE = "damage";
    private List<ItemStack> subTypes = null;

    public ItemFacade() {
        this.func_77627_a(true);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return AEApi.instance().partHelper().placeBus(player.func_184586_b(hand), pos, side, player, hand, world);
    }

    public String func_77653_i(ItemStack is) {
        try {
            ItemStack in = this.getTextureItem(is);
            if (!in.func_190926_b()) {
                return super.func_77653_i(is) + " - " + in.func_82833_r();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.func_77653_i(is);
    }

    @Override
    protected void getCheckedSubItems(CreativeTabs creativeTab, NonNullList<ItemStack> itemStacks) {
        this.calculateSubTypes();
        itemStacks.addAll(this.subTypes);
    }

    private void calculateSubTypes() {
        if (this.subTypes == null) {
            this.subTypes = new ArrayList<ItemStack>(1000);
            for (Object blk : Block.field_149771_c) {
                Block b = (Block)blk;
                try {
                    Item item = Item.func_150898_a((Block)b);
                    if (item == null) continue;
                    NonNullList tmpList = NonNullList.func_191196_a();
                    b.func_149666_a(b.func_149708_J(), tmpList);
                    for (ItemStack l : tmpList) {
                        ItemStack facade = this.createFacadeForItem(l, false);
                        if (facade.func_190926_b()) continue;
                        this.subTypes.add(facade);
                    }
                }
                catch (Throwable throwable) {
                }
            }
            if (FacadeConfig.instance().hasChanged()) {
                FacadeConfig.instance().save();
            }
        }
    }

    private static boolean hasSimpleModel(IBlockState blockState) {
        if (blockState.func_185901_i() != EnumBlockRenderType.MODEL || blockState instanceof IExtendedBlockState) {
            return false;
        }
        return blockState.func_185917_h();
    }

    public ItemStack createFacadeForItem(ItemStack l, boolean returnItem) {
        boolean defaultValue;
        IBlockState blockState;
        if (l.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Block b = Block.func_149634_a((Item)l.func_77973_b());
        if (b == null || l.func_77942_o() || b == Blocks.field_150350_a) {
            return ItemStack.field_190927_a;
        }
        int metadata = l.func_77973_b().func_77647_b(l.func_77952_i());
        boolean hasTile = b.hasTileEntity(b.func_176223_P());
        boolean enableGlass = b instanceof BlockGlass || b instanceof BlockStainedGlass;
        boolean disableOre = b instanceof BlockQuartzOre;
        try {
            blockState = b.func_176203_a(metadata);
        }
        catch (Exception e) {
            AELog.debug(e, "Cannot create a facade for " + b.getRegistryName());
            return ItemStack.field_190927_a;
        }
        boolean bl = defaultValue = b.func_185481_k(blockState) && ItemFacade.hasSimpleModel(blockState) && !b.func_149653_t() && !hasTile && !disableOre || enableGlass;
        if (FacadeConfig.instance().checkEnabled(b, metadata, defaultValue)) {
            if (returnItem) {
                return l;
            }
            ItemStack is = new ItemStack((Item)this);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a(TAG_ITEM_ID, l.func_77973_b().getRegistryName().toString());
            data.func_74768_a(TAG_DAMAGE, l.func_77952_i());
            is.func_77982_d(data);
            return is;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public FacadePart createPartFromItemStack(ItemStack is, AEPartLocation side) {
        ItemStack in = this.getTextureItem(is);
        if (!in.func_190926_b()) {
            return new FacadePart(is, side);
        }
        return null;
    }

    @Override
    public ItemStack getTextureItem(ItemStack is) {
        int itemDamage;
        ResourceLocation itemId;
        NBTTagCompound nbt = is.func_77978_p();
        if (nbt == null) {
            return ItemStack.field_190927_a;
        }
        if (nbt.func_74764_b("x")) {
            int[] data = nbt.func_74759_k("x");
            if (data.length != 2) {
                return ItemStack.field_190927_a;
            }
            Item item = (Item)Item.field_150901_e.func_148754_a(data[0]);
            if (item == null) {
                return ItemStack.field_190927_a;
            }
            itemId = item.getRegistryName();
            itemDamage = data[1];
        } else {
            itemId = new ResourceLocation(nbt.func_74779_i(TAG_ITEM_ID));
            itemDamage = nbt.func_74762_e(TAG_DAMAGE);
        }
        Item baseItem = (Item)Item.field_150901_e.func_82594_a((Object)itemId);
        if (baseItem == null) {
            return ItemStack.field_190927_a;
        }
        return new ItemStack(baseItem, 1, itemDamage);
    }

    @Override
    public IBlockState getTextureBlockState(ItemStack is) {
        ItemStack baseItemStack = this.getTextureItem(is);
        if (baseItemStack.func_190926_b()) {
            return Blocks.field_150359_w.func_176223_P();
        }
        Block block = Block.func_149634_a((Item)baseItemStack.func_77973_b());
        if (block == null) {
            return Blocks.field_150359_w.func_176223_P();
        }
        int metadata = baseItemStack.func_77973_b().getMetadata(baseItemStack);
        try {
            return block.func_176203_a(metadata);
        }
        catch (Exception e) {
            AELog.warn("Block %s has broken getStateFromMeta method for meta %d", block.getRegistryName().toString(), baseItemStack.func_77952_i());
            return Blocks.field_150359_w.func_176223_P();
        }
    }

    public List<ItemStack> getFacades() {
        this.calculateSubTypes();
        return this.subTypes;
    }

    public ItemStack getCreativeTabIcon() {
        this.calculateSubTypes();
        if (this.subTypes.isEmpty()) {
            return new ItemStack(Items.field_151105_aU);
        }
        return this.subTypes.get(0);
    }

    public ItemStack createFromIDs(int[] ids) {
        ItemStack facadeStack = AEApi.instance().definitions().items().facade().maybeStack(1).orElseThrow(() -> new MissingDefinition("Tried to create a facade, while facades are being deactivated."));
        Item item = (Item)Item.field_150901_e.func_148754_a(ids[0]);
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound facadeTag = new NBTTagCompound();
        facadeTag.func_74778_a(TAG_ITEM_ID, item.getRegistryName().toString());
        facadeTag.func_74768_a(TAG_DAMAGE, ids[1]);
        facadeStack.func_77982_d(facadeTag);
        return facadeStack;
    }

    @Override
    public boolean useAlphaPass(ItemStack is) {
        IBlockState blockState = this.getTextureBlockState(is);
        if (blockState == null) {
            return false;
        }
        Block blk = blockState.func_177230_c();
        return blk.canRenderInLayer(blockState, BlockRenderLayer.TRANSLUCENT);
    }
}

