/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools;

import appeng.api.config.SecurityPermissions;
import appeng.api.features.IPlayerRegistry;
import appeng.api.implementations.items.IBiometricCard;
import appeng.api.networking.security.ISecurityRegistry;
import appeng.core.localization.GuiText;
import appeng.items.AEBaseItem;
import appeng.util.Platform;
import com.mojang.authlib.GameProfile;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ToolBiometricCard
extends AEBaseItem
implements IBiometricCard {
    public ToolBiometricCard() {
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer p, EnumHand hand) {
        if (p.func_70093_af()) {
            this.encode(p.func_184586_b(hand), p);
            p.func_184609_a(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)p.func_184586_b(hand));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)p.func_184586_b(hand));
    }

    public boolean func_111207_a(ItemStack is, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        if (target instanceof EntityPlayer && !player.func_70093_af()) {
            if (player.field_71075_bZ.field_75098_d) {
                is = player.func_184586_b(hand);
            }
            this.encode(is, (EntityPlayer)target);
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    public String func_77653_i(ItemStack is) {
        GameProfile username = this.getProfile(is);
        return username != null ? super.func_77653_i(is) + " - " + username.getName() : super.func_77653_i(is);
    }

    private void encode(ItemStack is, EntityPlayer p) {
        GameProfile username = this.getProfile(is);
        if (username != null && username.equals((Object)p.func_146103_bH())) {
            this.setProfile(is, null);
        } else {
            this.setProfile(is, p.func_146103_bH());
        }
    }

    @Override
    public void setProfile(ItemStack itemStack, GameProfile profile) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        if (profile != null) {
            NBTTagCompound pNBT = new NBTTagCompound();
            NBTUtil.func_180708_a((NBTTagCompound)pNBT, (GameProfile)profile);
            tag.func_74782_a("profile", (NBTBase)pNBT);
        } else {
            tag.func_82580_o("profile");
        }
    }

    @Override
    public GameProfile getProfile(ItemStack is) {
        NBTTagCompound tag = Platform.openNbtData(is);
        if (tag.func_74764_b("profile")) {
            return NBTUtil.func_152459_a((NBTTagCompound)tag.func_74775_l("profile"));
        }
        return null;
    }

    @Override
    public EnumSet<SecurityPermissions> getPermissions(ItemStack is) {
        NBTTagCompound tag = Platform.openNbtData(is);
        EnumSet<SecurityPermissions> result = EnumSet.noneOf(SecurityPermissions.class);
        for (SecurityPermissions sp : SecurityPermissions.values()) {
            if (!tag.func_74767_n(sp.name())) continue;
            result.add(sp);
        }
        return result;
    }

    @Override
    public boolean hasPermission(ItemStack is, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(is);
        return tag.func_74767_n(permission.name());
    }

    @Override
    public void removePermission(ItemStack itemStack, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        if (tag.func_74764_b(permission.name())) {
            tag.func_82580_o(permission.name());
        }
    }

    @Override
    public void addPermission(ItemStack itemStack, SecurityPermissions permission) {
        NBTTagCompound tag = Platform.openNbtData(itemStack);
        tag.func_74757_a(permission.name(), true);
    }

    @Override
    public void registerPermissions(ISecurityRegistry register, IPlayerRegistry pr, ItemStack is) {
        register.addPlayer(pr.getID(this.getProfile(is)), this.getPermissions(is));
    }

    @Override
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, boolean displayMoreInfo) {
        EnumSet<SecurityPermissions> perms = this.getPermissions(stack);
        if (perms.isEmpty()) {
            lines.add(GuiText.NoPermissions.getLocal());
        } else {
            String msg = null;
            for (SecurityPermissions sp : perms) {
                if (msg == null) {
                    msg = Platform.gui_localize(sp.getUnlocalizedName());
                    continue;
                }
                msg = msg + ", " + Platform.gui_localize(sp.getUnlocalizedName());
            }
            lines.add(msg);
        }
    }
}

