/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.util.DimensionalCoord;
import appeng.block.misc.BlockTinyTNT;
import appeng.core.AEConfig;
import appeng.hooks.IBlockTool;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.InWorldToolOperationResult;
import appeng.util.Platform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class ToolEntropyManipulator
extends AEBasePoweredItem
implements IBlockTool {
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> heatUp = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();
    private final Map<InWorldToolOperationIngredient, InWorldToolOperationResult> coolDown = new HashMap<InWorldToolOperationIngredient, InWorldToolOperationResult>();

    public ToolEntropyManipulator() {
        super(AEConfig.instance().getEntropyManipulatorBattery());
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150348_b.func_176223_P()), new InWorldToolOperationResult(new ItemStack(Blocks.field_150347_e)));
        this.coolDown.put(new InWorldToolOperationIngredient(Blocks.field_150417_aV.func_176223_P()), new InWorldToolOperationResult(new ItemStack(Blocks.field_150417_aV, 1, 2)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150353_l, true), new InWorldToolOperationResult(new ItemStack(Blocks.field_150343_Z)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150356_k, true), new InWorldToolOperationResult(new ItemStack(Blocks.field_150343_Z)));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150349_c, true), new InWorldToolOperationResult(new ItemStack(Blocks.field_150346_d)));
        ArrayList<ItemStack> snowBalls = new ArrayList<ItemStack>();
        snowBalls.add(new ItemStack(Items.field_151126_ay));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150358_i, true), new InWorldToolOperationResult(ItemStack.field_190927_a, snowBalls));
        this.coolDown.put(new InWorldToolOperationIngredient((Block)Blocks.field_150355_j, true), new InWorldToolOperationResult(new ItemStack(Blocks.field_150432_aD)));
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150432_aD.func_176223_P()), new InWorldToolOperationResult(new ItemStack((Block)Blocks.field_150355_j)));
        this.heatUp.put(new InWorldToolOperationIngredient((Block)Blocks.field_150358_i, true), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient((Block)Blocks.field_150355_j, true), new InWorldToolOperationResult());
        this.heatUp.put(new InWorldToolOperationIngredient(Blocks.field_150433_aE, true), new InWorldToolOperationResult(new ItemStack((Block)Blocks.field_150358_i)));
    }

    private void heat(IBlockState state, World w, BlockPos pos) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(state));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(state.func_177230_c(), true));
        }
        if (!r.getBlockItem().func_190926_b()) {
            Block blk = Block.func_149634_a((Item)r.getBlockItem().func_77973_b());
            w.func_180501_a(pos, blk.func_176203_a(r.getBlockItem().func_77952_i()), 3);
        } else {
            w.func_175698_g(pos);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, pos, r.getDrops());
        }
    }

    private boolean canHeat(IBlockState state) {
        InWorldToolOperationResult r = this.heatUp.get(new InWorldToolOperationIngredient(state));
        if (r == null) {
            r = this.heatUp.get(new InWorldToolOperationIngredient(state.func_177230_c(), true));
        }
        return r != null;
    }

    private void cool(IBlockState state, World w, BlockPos pos) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(state));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(state.func_177230_c(), true));
        }
        if (!r.getBlockItem().func_190926_b()) {
            Block blk = Block.func_149634_a((Item)r.getBlockItem().func_77973_b());
            w.func_180501_a(pos, blk.func_176203_a(r.getBlockItem().func_77952_i()), 3);
        } else {
            w.func_175698_g(pos);
        }
        if (r.getDrops() != null) {
            Platform.spawnDrops(w, pos, r.getDrops());
        }
    }

    private boolean canCool(IBlockState state) {
        InWorldToolOperationResult r = this.coolDown.get(new InWorldToolOperationIngredient(state));
        if (r == null) {
            r = this.coolDown.get(new InWorldToolOperationIngredient(state.func_177230_c(), true));
        }
        return r != null;
    }

    public boolean func_77644_a(ItemStack item, EntityLivingBase target, EntityLivingBase hitter) {
        if (this.getAECurrentPower(item) > 1600.0) {
            this.extractAEPower(item, 1600.0);
            target.func_70015_d(8);
        }
        return false;
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer p, EnumHand hand) {
        IBlockState state;
        RayTraceResult target = this.func_77621_a(w, p, true);
        if (target == null) {
            return new ActionResult(EnumActionResult.PASS, (Object)p.func_184586_b(hand));
        }
        if (target.field_72313_a == RayTraceResult.Type.BLOCK && ((state = w.func_180495_p(target.func_178782_a())).func_185904_a() == Material.field_151587_i || state.func_185904_a() == Material.field_151586_h) && Platform.hasPermissions(new DimensionalCoord(w, target.func_178782_a()), p)) {
            this.func_180614_a(p, w, target.func_178782_a(), hand, EnumFacing.UP, 0.0f, 0.0f, 0.0f);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)p.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer p, World w, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack item = p.func_184586_b(hand);
        if (this.getAECurrentPower(item) > 1600.0) {
            if (!p.func_175151_a(pos, side, item)) {
                return EnumActionResult.PASS;
            }
            IBlockState state = w.func_180495_p(pos);
            Block blockID = state.func_177230_c();
            if (p.func_70093_af()) {
                if (this.canCool(state)) {
                    this.extractAEPower(item, 1600.0);
                    this.cool(state, w, pos);
                    return EnumActionResult.SUCCESS;
                }
            } else {
                if (blockID instanceof BlockTNT) {
                    w.func_175698_g(pos);
                    ((BlockTNT)blockID).func_180692_a(w, pos, state, (EntityLivingBase)p);
                    return EnumActionResult.SUCCESS;
                }
                if (blockID instanceof BlockTinyTNT) {
                    w.func_175698_g(pos);
                    ((BlockTinyTNT)blockID).startFuse(w, pos, (EntityLivingBase)p);
                    return EnumActionResult.SUCCESS;
                }
                if (this.canHeat(state)) {
                    this.extractAEPower(item, 1600.0);
                    this.heat(state, w, pos);
                    return EnumActionResult.SUCCESS;
                }
                ItemStack[] stack = Platform.getBlockDrops(w, pos);
                ArrayList<ItemStack> out = new ArrayList<ItemStack>();
                boolean hasFurnaceable = false;
                boolean canFurnaceable = true;
                for (ItemStack i : stack) {
                    if (i.func_190926_b()) continue;
                    ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(i);
                    if (!result.func_190926_b()) {
                        if (result.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)result.func_77973_b()) == blockID && result.func_77973_b().getDamage(result) == blockID.func_176201_c(state)) {
                            canFurnaceable = false;
                        }
                        hasFurnaceable = true;
                        out.add(result);
                        continue;
                    }
                    canFurnaceable = false;
                    out.add(i);
                }
                if (hasFurnaceable && canFurnaceable) {
                    this.extractAEPower(item, 1600.0);
                    InWorldToolOperationResult or = InWorldToolOperationResult.getBlockOperationResult(out.toArray(new ItemStack[out.size()]));
                    w.func_184148_a(p, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    if (or.getBlockItem().func_190926_b()) {
                        w.func_180501_a(pos, Platform.AIR_BLOCK.func_176223_P(), 3);
                    } else {
                        Block blk = Block.func_149634_a((Item)or.getBlockItem().func_77973_b());
                        w.func_180501_a(pos, blk.func_176203_a(or.getBlockItem().func_77952_i()), 3);
                    }
                    if (or.getDrops() != null) {
                        Platform.spawnDrops(w, pos, or.getDrops());
                    }
                    return EnumActionResult.SUCCESS;
                }
                BlockPos offsetPos = pos.func_177972_a(side);
                if (!p.func_175151_a(offsetPos, side, item)) {
                    return EnumActionResult.PASS;
                }
                if (w.func_175623_d(offsetPos)) {
                    this.extractAEPower(item, 1600.0);
                    w.func_184148_a(p, (double)offsetPos.func_177958_n() + 0.5, (double)offsetPos.func_177956_o() + 0.5, (double)offsetPos.func_177952_p() + 0.5, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
                    w.func_175656_a(offsetPos, Blocks.field_150480_ab.func_176223_P());
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    private static class InWorldToolOperationIngredient {
        private final IBlockState state;
        private final boolean blockOnly;

        public InWorldToolOperationIngredient(IBlockState state) {
            this.state = state;
            this.blockOnly = false;
        }

        public InWorldToolOperationIngredient(Block blk, boolean b) {
            this.state = blk.func_176223_P();
            this.blockOnly = b;
        }

        public int hashCode() {
            return this.state.func_177230_c().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InWorldToolOperationIngredient other = (InWorldToolOperationIngredient)obj;
            return this.state == other.state && this.blockOnly && this.state.func_177230_c() == other.state.func_177230_c();
        }
    }
}

