/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.tools.powered;

import appeng.api.AEApi;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.features.IWirelessTermHandler;
import appeng.api.util.IConfigManager;
import appeng.capabilities.Capabilities;
import appeng.core.AEConfig;
import appeng.core.localization.GuiText;
import appeng.items.tools.powered.powersink.AEBasePoweredItem;
import appeng.util.ConfigManager;
import appeng.util.IConfigManagerHost;
import appeng.util.Platform;
import baubles.api.BaubleType;
import baubles.api.cap.BaubleItem;
import baubles.api.render.IRenderBauble;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Optional.Interface(iface="baubles.api.render.IRenderBauble", modid="baubles")
public class ToolWirelessTerminal
extends AEBasePoweredItem
implements IWirelessTermHandler,
IRenderBauble {
    private static String EGG_KEY = "hasQuantumEgg";

    public ToolWirelessTerminal() {
        super(AEConfig.instance().getWirelessTerminalBattery());
    }

    public ActionResult<ItemStack> func_77659_a(World w, EntityPlayer player, EnumHand hand) {
        AEApi.instance().registries().wireless().openWirelessTerminalGui(player.func_184586_b(hand), w, player);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return false;
    }

    @Override
    public void addCheckedInformation(ItemStack stack, World world, List<String> lines, boolean displayMoreInfo) {
        super.addCheckedInformation(stack, world, lines, displayMoreInfo);
        if (stack.func_77942_o()) {
            NBTTagCompound tag = Platform.openNbtData(stack);
            if (tag != null) {
                String encKey = tag.func_74779_i("encryptionKey");
                if (encKey == null || encKey.isEmpty()) {
                    lines.add(GuiText.Unlinked.getLocal());
                } else {
                    lines.add(GuiText.Linked.getLocal());
                }
                if (ToolWirelessTerminal.getHasQuantumEgg(stack)) {
                    lines.add(net.minecraft.client.resources.I18n.func_135052_a((String)"gui.tooltips.appliedenergistics2.egg_upgrade", (Object[])new Object[0]));
                }
            }
        } else {
            lines.add(I18n.func_74838_a((String)"AppEng.GuiITooltip.Unlinked"));
        }
    }

    @Override
    public boolean canHandle(ItemStack is) {
        return AEApi.instance().definitions().items().wirelessTerminal().isSameAs(is);
    }

    @Override
    public boolean usePower(EntityPlayer player, double amount, ItemStack is) {
        return this.extractAEPower(is, amount) >= amount - 0.5;
    }

    @Override
    public boolean hasPower(EntityPlayer player, double amt, ItemStack is) {
        return this.getAECurrentPower(is) >= amt;
    }

    @Override
    public IConfigManager getConfigManager(final ItemStack target) {
        ConfigManager out = new ConfigManager(new IConfigManagerHost(){

            @Override
            public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
                NBTTagCompound data = Platform.openNbtData(target);
                manager.writeToNBT(data);
            }
        });
        out.registerSetting(Settings.SORT_BY, (Enum)SortOrder.NAME);
        out.registerSetting(Settings.VIEW_MODE, (Enum)ViewItems.ALL);
        out.registerSetting(Settings.SORT_DIRECTION, (Enum)SortDir.ASCENDING);
        out.readFromNBT(Platform.openNbtData(target).func_74737_b());
        return out;
    }

    @Override
    public String getEncryptionKey(ItemStack item) {
        NBTTagCompound tag = Platform.openNbtData(item);
        return tag.func_74779_i("encryptionKey");
    }

    @Override
    public void setEncryptionKey(ItemStack item, String encKey, String name) {
        NBTTagCompound tag = Platform.openNbtData(item);
        tag.func_74778_a("encryptionKey", encKey);
        tag.func_74778_a("name", name);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public static void setHasQuantumEgg(ItemStack is, boolean val) {
        if (is.func_77978_p() == null) {
            is.func_77982_d(new NBTTagCompound());
        }
        is.func_77978_p().func_74757_a(EGG_KEY, val);
    }

    public static boolean getHasQuantumEgg(ItemStack is) {
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b(EGG_KEY)) {
            return is.func_77978_p().func_74767_n(EGG_KEY);
        }
        return false;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        ICapabilityProvider parent = super.initCapabilities(stack, nbt);
        return Capabilities.CAPABILITY_ITEM_BAUBLE != null ? new BaubleHandler(parent) : parent;
    }

    @SideOnly(value=Side.CLIENT)
    @Optional.Method(modid="baubles")
    public void onPlayerBaubleRender(ItemStack stack, EntityPlayer player, IRenderBauble.RenderType type, float partialTicks) {
        if (type == IRenderBauble.RenderType.HEAD) {
            IRenderBauble.Helper.translateToHeadLevel((EntityPlayer)player);
            if (player.func_70093_af()) {
                IRenderBauble.Helper.rotateIfSneaking((EntityPlayer)player);
            }
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.HEAD);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return ToolWirelessTerminal.getHasQuantumEgg(stack);
    }

    private static class BaubleHandler
    implements ICapabilityProvider {
        @Nullable
        private final ICapabilityProvider parent;
        private final BaubleItem bauble = new BaubleItem(BaubleType.HEAD){

            public boolean willAutoSync(ItemStack itemstack, EntityLivingBase player) {
                return true;
            }
        };

        public BaubleHandler(ICapabilityProvider p) {
            this.parent = p;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == Capabilities.CAPABILITY_ITEM_BAUBLE || this.parent != null && this.parent.hasCapability(capability, facing);
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == Capabilities.CAPABILITY_ITEM_BAUBLE) {
                return (T)Capabilities.CAPABILITY_ITEM_BAUBLE.cast((Object)this.bauble);
            }
            return (T)(this.parent != null ? this.parent.getCapability(capability, facing) : null);
        }
    }
}

