/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.AEApi;
import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.IConfigManager;
import appeng.core.AEConfig;
import appeng.core.sync.GuiBridge;
import appeng.helpers.IPriorityHost;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.storage.MEInventoryHandler;
import appeng.parts.automation.PartUpgradeable;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModels;
import appeng.tile.inventory.AppEngInternalAEInventory;
import appeng.tile.inventory.InvOperation;
import appeng.util.Platform;
import appeng.util.prioritylist.FuzzyPriorityList;
import appeng.util.prioritylist.PrecisePriorityList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFirework;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.IPlantable;

public class PartFormationPlane
extends PartUpgradeable
implements ICellContainer,
IPriorityHost,
IMEInventory<IAEItemStack> {
    private static final PlaneModels MODELS = new PlaneModels("part/formation_plane_", "part/formation_plane_on_");
    private final MEInventoryHandler myHandler = new MEInventoryHandler<IAEItemStack>(this, StorageChannel.ITEMS);
    private final AppEngInternalAEInventory Config = new AppEngInternalAEInventory(this, 63);
    private int priority = 0;
    private boolean wasActive = false;
    private boolean blocked = false;
    private boolean laidEgg = false;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public PartFormationPlane(ItemStack is) {
        super(is);
        this.getConfigManager().registerSetting(Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.getConfigManager().registerSetting(Settings.PLACE_BLOCK, YesNo.YES);
        this.updateHandler();
    }

    private void updateHandler() {
        this.myHandler.setBaseAccess(AccessRestriction.WRITE);
        this.myHandler.setWhitelist(this.getInstalledUpgrades(Upgrades.INVERTER) > 0 ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.myHandler.setPriority(this.priority);
        IItemList<IAEItemStack> priorityList = AEApi.instance().storage().createItemList();
        int slotsToUse = 18 + this.getInstalledUpgrades(Upgrades.CAPACITY) * 9;
        for (int x = 0; x < this.Config.func_70302_i_() && x < slotsToUse; ++x) {
            IAEItemStack is = this.Config.getAEStackInSlot(x);
            if (is == null) continue;
            priorityList.add(is);
        }
        if (this.getInstalledUpgrades(Upgrades.FUZZY) > 0) {
            this.myHandler.setPartitionList(new FuzzyPriorityList<IAEItemStack>(priorityList, (FuzzyMode)this.getConfigManager().getSetting(Settings.FUZZY_MODE)));
        } else {
            this.myHandler.setPartitionList(new PrecisePriorityList<IAEItemStack>(priorityList));
        }
        try {
            this.getProxy().getGrid().postEvent(new MENetworkCellArrayUpdate());
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    @Override
    protected int getUpgradeSlots() {
        return 5;
    }

    @Override
    public void updateSetting(IConfigManager manager, Enum settingName, Enum newValue) {
        this.updateHandler();
        this.getHost().markForSave();
    }

    @Override
    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        super.onChangeInventory(inv, slot, mc, removedStack, newStack);
        if (inv == this.Config) {
            this.updateHandler();
        }
    }

    @Override
    public void upgradesChanged() {
        this.updateHandler();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.Config.readFromNBT(data, "config");
        this.priority = data.func_74762_e("priority");
        this.laidEgg = data.func_74767_n("laid_egg");
        this.updateHandler();
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        this.Config.writeToNBT(data, "config");
        data.func_74768_a("priority", this.priority);
        data.func_74757_a("laid_egg", this.laidEgg);
    }

    @Override
    public IInventory getInventoryByName(String name) {
        if (name.equals("config")) {
            return this.Config;
        }
        return super.getInventoryByName(name);
    }

    @Override
    @MENetworkEventSubscribe
    public void powerRender(MENetworkPowerStatusChange c) {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @MENetworkEventSubscribe
    public void updateChannels(MENetworkChannelsChanged changedChannels) {
        boolean currentActive = this.getProxy().isActive();
        if (this.wasActive != currentActive) {
            this.wasActive = currentActive;
            this.updateHandler();
            this.getHost().markForUpdate();
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        boolean minX = true;
        boolean minY = true;
        int maxX = 15;
        int maxY = 15;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            EnumFacing e = bch.getWorldX();
            EnumFacing u = bch.getWorldY();
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e.func_176734_d())), this.getSide())) {
                minX = false;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(e)), this.getSide())) {
                maxX = 16;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u.func_176734_d())), this.getSide())) {
                minY = false;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(u)), this.getSide())) {
                maxY = 16;
            }
        }
        bch.addBox(5.0, 5.0, 14.0, 11.0, 11.0, 15.0);
        bch.addBox((double)minX, (double)minY, 15.0, maxX, maxY, 16.0);
    }

    public PlaneConnections getConnections() {
        EnumFacing facingUp;
        EnumFacing facingRight;
        AEPartLocation location = this.getSide();
        switch (location) {
            case UP: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case DOWN: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.NORTH;
                break;
            }
            case NORTH: {
                facingRight = EnumFacing.WEST;
                facingUp = EnumFacing.UP;
                break;
            }
            case SOUTH: {
                facingRight = EnumFacing.EAST;
                facingUp = EnumFacing.UP;
                break;
            }
            case WEST: {
                facingRight = EnumFacing.SOUTH;
                facingUp = EnumFacing.UP;
                break;
            }
            case EAST: {
                facingRight = EnumFacing.NORTH;
                facingUp = EnumFacing.UP;
                break;
            }
            default: {
                return PlaneConnections.of(false, false, false, false);
            }
        }
        boolean left = false;
        boolean right = false;
        boolean down = false;
        boolean up = false;
        IPartHost host = this.getHost();
        if (host != null) {
            TileEntity te = host.getTile();
            BlockPos pos = te.func_174877_v();
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight.func_176734_d())), this.getSide())) {
                left = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingRight)), this.getSide())) {
                right = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp.func_176734_d())), this.getSide())) {
                down = true;
            }
            if (this.isTransitionPlane(te.func_145831_w().func_175625_s(pos.func_177972_a(facingUp)), this.getSide())) {
                up = true;
            }
        }
        return PlaneConnections.of(up, right, down, left);
    }

    @Override
    public void onNeighborChanged() {
        TileEntity te = this.getHost().getTile();
        World w = te.func_145831_w();
        AEPartLocation side = this.getSide();
        BlockPos tePos = te.func_174877_v().func_177972_a(side.getFacing());
        this.blocked = !w.func_180495_p(tePos).func_177230_c().func_176200_f((IBlockAccess)w, tePos);
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    public boolean onPartActivate(EntityPlayer player, EnumHand hand, Vec3d pos) {
        if (!player.func_70093_af()) {
            if (Platform.isClient()) {
                return true;
            }
            Platform.openGUI(player, this.getHost().getTile(), this.getSide(), GuiBridge.GUI_FORMATION_PLANE);
            return true;
        }
        return false;
    }

    private boolean isTransitionPlane(TileEntity blockTileEntity, AEPartLocation side) {
        if (blockTileEntity instanceof IPartHost) {
            IPart p = ((IPartHost)blockTileEntity).getPart(side);
            return p instanceof PartFormationPlane;
        }
        return false;
    }

    @Override
    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (this.getProxy().isActive() && channel == StorageChannel.ITEMS) {
            ArrayList<IMEInventoryHandler> Handler = new ArrayList<IMEInventoryHandler>(1);
            Handler.add(this.myHandler);
            return Handler;
        }
        return new ArrayList<IMEInventoryHandler>();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.updateHandler();
    }

    @Override
    public void blinkCell(int slot) {
    }

    @Override
    public IAEItemStack injectItems(IAEItemStack input, Actionable type, BaseActionSource src) {
        if (this.blocked || input == null || input.getStackSize() <= 0L) {
            return input;
        }
        YesNo placeBlock = (YesNo)this.getConfigManager().getSetting(Settings.PLACE_BLOCK);
        ItemStack is = input.getItemStack();
        Item i = is.func_77973_b();
        long maxStorage = Math.min(input.getStackSize(), (long)is.func_77976_d());
        boolean worked = false;
        TileEntity te = this.getHost().getTile();
        World w = te.func_145831_w();
        AEPartLocation side = this.getSide();
        BlockPos tePos = te.func_174877_v().func_177972_a(side.getFacing());
        if (w.func_180495_p(tePos).func_177230_c().func_176200_f((IBlockAccess)w, tePos)) {
            if (placeBlock == YesNo.YES && (i instanceof ItemBlock || i instanceof IPlantable || i instanceof ItemSkull || i instanceof ItemFirework || i instanceof IPartItem || i == Item.func_150898_a((Block)Blocks.field_150436_aH))) {
                maxStorage = is.func_190916_E();
                worked = true;
                if (type == Actionable.MODULATE) {
                    EntityPlayer player = Platform.getPlayer((WorldServer)w);
                    Platform.configurePlayer(player, side, this.getTile());
                    player.func_184611_a(EnumHand.MAIN_HAND, is);
                    if (i instanceof IPlantable || i instanceof ItemSkull || i == Item.func_150898_a((Block)Blocks.field_150436_aH)) {
                        boolean Worked = false;
                        if (side.xOffset == 0 && side.zOffset == 0) {
                            boolean bl = Worked = i.func_180614_a(player, w, tePos.func_177972_a(side.getFacing()), EnumHand.MAIN_HAND, side.getFacing().func_176734_d(), (float)side.xOffset, (float)side.yOffset, (float)side.zOffset) == EnumActionResult.SUCCESS;
                        }
                        if (!Worked && side.xOffset == 0 && side.zOffset == 0) {
                            boolean bl = Worked = i.func_180614_a(player, w, tePos.func_177972_a(side.getFacing().func_176734_d()), EnumHand.MAIN_HAND, side.getFacing(), (float)side.xOffset, (float)side.yOffset, (float)side.zOffset) == EnumActionResult.SUCCESS;
                        }
                        if (!Worked && side.yOffset == 0) {
                            boolean bl = Worked = i.func_180614_a(player, w, tePos.func_177972_a(EnumFacing.DOWN), EnumHand.MAIN_HAND, EnumFacing.UP, (float)side.xOffset, (float)side.yOffset, (float)side.zOffset) == EnumActionResult.SUCCESS;
                        }
                        if (!Worked) {
                            i.func_180614_a(player, w, tePos, EnumHand.MAIN_HAND, side.getFacing().func_176734_d(), (float)side.xOffset, (float)side.yOffset, (float)side.zOffset);
                        }
                        maxStorage -= (long)is.func_190916_E();
                    } else {
                        i.func_180614_a(player, w, tePos, EnumHand.MAIN_HAND, side.getFacing().func_176734_d(), (float)side.xOffset, (float)side.yOffset, (float)side.zOffset);
                        maxStorage -= (long)is.func_190916_E();
                    }
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                } else {
                    maxStorage = 1L;
                }
            } else {
                worked = true;
                Chunk c = w.func_175726_f(tePos);
                int sum = 0;
                for (ClassInheritanceMultiMap Z : c.func_177429_s()) {
                    sum += Z.size();
                }
                if (sum < AEConfig.instance().getFormationPlaneEntityLimit()) {
                    if (type == Actionable.MODULATE) {
                        EntityItem ei;
                        is.func_190920_e((int)maxStorage);
                        double x = (side.xOffset != 0 ? 0.0 : 0.7 * ((double)Platform.getRandomFloat() - 0.5)) + (double)side.xOffset + 0.5 + (double)te.func_174877_v().func_177958_n();
                        double y = (side.yOffset != 0 ? 0.0 : 0.7 * ((double)Platform.getRandomFloat() - 0.5)) + (double)side.yOffset + 0.5 + (double)te.func_174877_v().func_177956_o();
                        double z = (side.zOffset != 0 ? 0.0 : 0.7 * ((double)Platform.getRandomFloat() - 0.5)) + (double)side.zOffset + 0.5 + (double)te.func_174877_v().func_177952_p();
                        EntityItem result = ei = new EntityItem(w, x, y, z, is.func_77946_l());
                        ei.field_70159_w = (double)side.xOffset * 0.2;
                        ei.field_70181_x = (double)side.yOffset * 0.2;
                        ei.field_70179_y = (double)side.zOffset * 0.2;
                        if (is.func_77973_b().hasCustomEntity(is)) {
                            result = is.func_77973_b().createEntity(w, (Entity)ei, is);
                            if (result != null) {
                                ei.func_70106_y();
                            } else {
                                result = ei;
                            }
                        }
                        if (!this.laidEgg && is.func_77973_b() == Items.field_151057_cb && is.func_82837_s()) {
                            if (is.func_82833_r().equals("Carl")) {
                                EntityLlama llama = new EntityLlama(w);
                                result = llama;
                                ei.func_70106_y();
                                maxStorage = 1L;
                                llama.func_96094_a(is.func_82833_r());
                                llama.func_110163_bv();
                                BlockPos spawnPos = te.func_174877_v().func_177972_a(side.getFacing());
                                llama.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                                this.laidEgg = true;
                            } else if (is.func_82833_r().equals("Polly")) {
                                EntityParrot parrot = new EntityParrot(w);
                                result = parrot;
                                ei.func_70106_y();
                                maxStorage = 1L;
                                parrot.func_96094_a(is.func_82833_r());
                                parrot.func_110163_bv();
                                BlockPos spawnPos = te.func_174877_v().func_177972_a(side.getFacing());
                                parrot.func_70107_b((double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p());
                                this.laidEgg = true;
                            }
                        }
                        if (!w.func_72838_d((Entity)result)) {
                            result.func_70106_y();
                            worked = false;
                        }
                    }
                } else {
                    worked = false;
                }
            }
        }
        boolean bl = this.blocked = !w.func_180495_p(tePos).func_177230_c().func_176200_f((IBlockAccess)w, tePos);
        if (worked) {
            IAEItemStack out = input.copy();
            out.decStackSize(maxStorage);
            if (out.getStackSize() == 0L) {
                return null;
            }
            return out;
        }
        return input;
    }

    @Override
    public IAEItemStack extractItems(IAEItemStack request, Actionable mode, BaseActionSource src) {
        return null;
    }

    @Override
    public IItemList<IAEItemStack> getAvailableItems(IItemList<IAEItemStack> out) {
        return out;
    }

    @Override
    public StorageChannel getChannel() {
        return StorageChannel.ITEMS;
    }

    @Override
    public void saveChanges(IMEInventory cellInventory) {
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.getConnections(), this.isPowered(), this.isActive());
    }
}

