/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.networking;

import appeng.api.config.Actionable;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.energy.IEnergyGridProvider;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartModel;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.items.parts.PartModels;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.parts.AEBasePart;
import appeng.parts.PartModel;
import java.util.Deque;
import java.util.EnumSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;

public class PartQuartzFiber
extends AEBasePart
implements IEnergyGridProvider {
    @PartModels
    private static final IPartModel MODELS = new PartModel(new ResourceLocation("appliedenergistics2", "part/quartz_fiber"));
    private final AENetworkProxy outerProxy = new AENetworkProxy(this, "outer", this.getProxy().getMachineRepresentation(), true);

    public PartQuartzFiber(ItemStack is) {
        super(is);
        this.getProxy().setIdlePowerUsage(0.0);
        this.getProxy().setFlags(GridFlags.CANNOT_CARRY);
        this.outerProxy.setIdlePowerUsage(0.0);
        this.outerProxy.setFlags(GridFlags.CANNOT_CARRY);
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.GLASS;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(6.0, 6.0, 10.0, 10.0, 10.0, 16.0);
    }

    @Override
    public void readFromNBT(NBTTagCompound extra) {
        super.readFromNBT(extra);
        this.outerProxy.readFromNBT(extra);
    }

    @Override
    public void writeToNBT(NBTTagCompound extra) {
        super.writeToNBT(extra);
        this.outerProxy.writeToNBT(extra);
    }

    @Override
    public void removeFromWorld() {
        super.removeFromWorld();
        this.outerProxy.invalidate();
    }

    @Override
    public void addToWorld() {
        super.addToWorld();
        this.outerProxy.onReady();
    }

    @Override
    public void setPartHostInfo(AEPartLocation side, IPartHost host, TileEntity tile) {
        super.setPartHostInfo(side, host, tile);
        this.outerProxy.setValidSides(EnumSet.of(side.getFacing()));
    }

    @Override
    public IGridNode getExternalFacingNode() {
        return this.outerProxy.getNode();
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 16.0f;
    }

    @Override
    public void onPlacement(EntityPlayer player, EnumHand hand, ItemStack held, AEPartLocation side) {
        super.onPlacement(player, hand, held, side);
        this.outerProxy.setOwner(player);
    }

    @Override
    public double extractAEPower(double amt, Actionable mode, Deque<IEnergyGridProvider> seen) {
        IEnergyGrid eg2;
        double acquiredPower = 0.0;
        try {
            eg2 = this.getProxy().getEnergy();
            acquiredPower += eg2.extractAEPower(amt - acquiredPower, mode, seen);
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            acquiredPower += eg2.extractAEPower(amt - acquiredPower, mode, seen);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return acquiredPower;
    }

    @Override
    public double injectAEPower(double amt, Actionable mode, Deque<IEnergyGridProvider> seen) {
        IEnergyGrid eg2;
        try {
            eg2 = this.getProxy().getEnergy();
            if (!seen.contains(eg2)) {
                return eg2.injectAEPower(amt, mode, seen);
            }
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            if (!seen.contains(eg2)) {
                return eg2.injectAEPower(amt, mode, seen);
            }
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return amt;
    }

    @Override
    public double getEnergyDemand(double amt, Deque<IEnergyGridProvider> seen) {
        IEnergyGrid eg2;
        double demand = 0.0;
        try {
            eg2 = this.getProxy().getEnergy();
            demand += eg2.getEnergyDemand(amt - demand, seen);
        }
        catch (GridAccessException eg2) {
            // empty catch block
        }
        try {
            eg2 = this.outerProxy.getEnergy();
            demand += eg2.getEnergyDemand(amt - demand, seen);
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
        return demand;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS;
    }
}

